/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.drools.RuleBaseConfiguration;
import org.drools.base.ClassObjectType;
import org.drools.common.BetaConstraints;
import org.drools.common.DoubleBetaConstraints;
import org.drools.common.DoubleNonIndexSkipBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.Memory;
import org.drools.common.NodeMemory;
import org.drools.common.QuadroupleBetaConstraints;
import org.drools.common.QuadroupleNonIndexSkipBetaConstraints;
import org.drools.common.RuleBasePartitionId;
import org.drools.common.SingleBetaConstraints;
import org.drools.common.SingleNonIndexSkipBetaConstraints;
import org.drools.common.TripleBetaConstraints;
import org.drools.common.TripleNonIndexSkipBetaConstraints;
import org.drools.common.UpdateContext;
import org.drools.core.util.BitMaskUtil;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.index.IndexUtil;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.ConcurrentRightTuple;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MemoryVisitor;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.NodeSet;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.PropagationQueuingNode;
import org.drools.reteoo.PropertySpecificUtil;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;
import org.drools.reteoo.RightTupleSink;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.WindowTuple;
import org.drools.reteoo.WindowTupleList;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.IndexableConstraint;
import org.drools.rule.Pattern;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BetaNode
extends LeftTupleSource
implements LeftTupleSinkNode,
ObjectSinkNode,
RightTupleSink,
NodeMemory {
    protected LeftTupleSource leftInput;
    protected ObjectSource rightInput;
    protected BetaConstraints constraints;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;
    protected boolean objectMemory = true;
    protected boolean tupleMemoryEnabled;
    protected boolean concurrentRightTupleMemory = false;
    protected boolean lrUnlinkingEnabled = false;
    private boolean indexedUnificationJoin;
    private long rightDeclaredMask;
    private long rightInferredMask;
    private long rightNegativeMask;
    private List<String> leftListenedProperties;
    private List<String> rightListenedProperties;
    private transient ObjectTypeNode.Id rightInputOtnId = ObjectTypeNode.DEFAULT_ID;
    private transient ObjectTypeNode objectTypeNode;

    public BetaNode() {
    }

    BetaNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints constraints, BuildContext context) {
        super(id, partitionId, partitionsEnabled);
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.constraints = constraints;
        if (this.constraints == null) {
            throw new RuntimeException("cannot have null constraints, must at least be an instance of EmptyBetaConstraints");
        }
        this.initMasks(context, leftInput);
    }

    @Override
    protected void initDeclaredMask(BuildContext context, LeftTupleSource leftInput) {
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.rightDeclaredMask = -1L;
            super.initDeclaredMask(context, leftInput);
            return;
        }
        if (!(this.rightInput instanceof RightInputAdapterNode)) {
            Pattern pattern = context.getLastBuiltPatterns()[0];
            ObjectType objectType = pattern.getObjectType();
            if (objectType instanceof ClassObjectType) {
                Class<?> objectClass = ((ClassObjectType)objectType).getClassType();
                if (PropertySpecificUtil.isPropertyReactive(context, objectClass)) {
                    this.rightListenedProperties = pattern.getListenedProperties();
                    List<String> settableProperties = PropertySpecificUtil.getSettableProperties(context.getRuleBase(), objectClass);
                    this.rightDeclaredMask = PropertySpecificUtil.calculatePositiveMask(this.rightListenedProperties, settableProperties);
                    this.rightDeclaredMask |= this.constraints.getListenedPropertyMask(settableProperties);
                    this.rightNegativeMask = PropertySpecificUtil.calculateNegativeMask(this.rightListenedProperties, settableProperties);
                } else {
                    this.rightDeclaredMask = -1L;
                }
            } else {
                this.rightDeclaredMask = -1L;
            }
        } else {
            this.rightDeclaredMask = -1L;
            context.setLastBuiltPattern(context.getLastBuiltPatterns()[0]);
        }
        super.initDeclaredMask(context, leftInput);
    }

    @Override
    protected void setLeftListenedProperties(List<String> leftListenedProperties) {
        this.leftListenedProperties = leftListenedProperties;
    }

    public void initInferredMask() {
        this.initInferredMask(this.leftInput);
    }

    @Override
    protected void initInferredMask(LeftTupleSource leftInput) {
        super.initInferredMask(leftInput);
        ObjectSource unwrappedRight = this.unwrapRightInput();
        if (unwrappedRight instanceof AlphaNode) {
            AlphaNode alphaNode = (AlphaNode)unwrappedRight;
            this.rightInferredMask = alphaNode.updateMask(this.rightDeclaredMask);
        } else {
            this.rightInferredMask = this.rightDeclaredMask;
        }
        this.rightInferredMask &= -1L - this.rightNegativeMask;
    }

    public ObjectSource unwrapRightInput() {
        return this.rightInput instanceof PropagationQueuingNode ? this.rightInput.getParentObjectSource() : this.rightInput;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraints = (BetaConstraints)in.readObject();
        this.leftInput = (LeftTupleSource)in.readObject();
        this.rightInput = (ObjectSource)in.readObject();
        this.objectMemory = in.readBoolean();
        this.tupleMemoryEnabled = in.readBoolean();
        this.concurrentRightTupleMemory = in.readBoolean();
        this.lrUnlinkingEnabled = in.readBoolean();
        this.rightDeclaredMask = in.readLong();
        this.rightInferredMask = in.readLong();
        this.rightNegativeMask = in.readLong();
        this.leftListenedProperties = (List)in.readObject();
        this.rightListenedProperties = (List)in.readObject();
        this.setUnificationJoin();
        super.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        BetaNodeFieldConstraint c;
        BetaNodeFieldConstraint[] betaCconstraints = this.constraints.getConstraints();
        if (betaCconstraints.length > 0 && IndexUtil.isIndexable(c = betaCconstraints[0], this.getType()) && ((IndexableConstraint)((Object)c)).isUnification()) {
            this.constraints = this.constraints.getOriginalConstraint();
        }
        out.writeObject(this.constraints);
        out.writeObject(this.leftInput);
        out.writeObject(this.rightInput);
        out.writeBoolean(this.objectMemory);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeBoolean(this.concurrentRightTupleMemory);
        out.writeBoolean(this.lrUnlinkingEnabled);
        out.writeLong(this.rightDeclaredMask);
        out.writeLong(this.rightInferredMask);
        out.writeLong(this.rightNegativeMask);
        out.writeObject(this.leftListenedProperties);
        out.writeObject(this.rightListenedProperties);
        super.writeExternal(out);
    }

    private void setUnificationJoin() {
        BetaNodeFieldConstraint c;
        BetaNodeFieldConstraint[] betaCconstraints = this.constraints.getConstraints();
        if (betaCconstraints.length > 0 && IndexUtil.isIndexable(c = betaCconstraints[0], this.getType()) && ((IndexableConstraint)((Object)c)).isUnification()) {
            if (this.constraints instanceof SingleBetaConstraints) {
                this.constraints = new SingleNonIndexSkipBetaConstraints((SingleBetaConstraints)this.constraints);
            } else if (this.constraints instanceof DoubleBetaConstraints) {
                this.constraints = new DoubleNonIndexSkipBetaConstraints((DoubleBetaConstraints)this.constraints);
            } else if (this.constraints instanceof TripleBetaConstraints) {
                this.constraints = new TripleNonIndexSkipBetaConstraints((TripleBetaConstraints)this.constraints);
            } else if (this.constraints instanceof QuadroupleBetaConstraints) {
                this.constraints = new QuadroupleNonIndexSkipBetaConstraints((QuadroupleBetaConstraints)this.constraints);
            }
            this.indexedUnificationJoin = true;
        }
    }

    public FastIterator getRightIterator(RightTupleMemory memory) {
        if (!this.indexedUnificationJoin) {
            return memory.fastIterator();
        }
        return memory.fullFastIterator();
    }

    public FastIterator getRightIterator(RightTupleMemory memory, RightTuple rightTuple) {
        if (!this.indexedUnificationJoin) {
            return memory.fastIterator();
        }
        return memory.fullFastIterator(rightTuple);
    }

    public FastIterator getLeftIterator(LeftTupleMemory memory) {
        if (!this.indexedUnificationJoin) {
            return memory.fastIterator();
        }
        return memory.fullFastIterator();
    }

    public RightTuple getFirstRightTuple(LeftTuple leftTuple, RightTupleMemory memory, PropagationContext context, FastIterator it) {
        if (!this.indexedUnificationJoin) {
            return memory.getFirst(leftTuple, (InternalFactHandle)context.getFactHandle(), it);
        }
        return (RightTuple)it.next(null);
    }

    public LeftTuple getFirstLeftTuple(RightTuple rightTuple, LeftTupleMemory memory, PropagationContext context, FastIterator it) {
        if (!this.indexedUnificationJoin) {
            return memory.getFirst(rightTuple);
        }
        return (LeftTuple)it.next(null);
    }

    public static RightTuple getFirstRightTuple(RightTupleMemory memory, FastIterator it) {
        if (!memory.isIndexed()) {
            return memory.getFirst(null, null, it);
        }
        return (RightTuple)it.next(null);
    }

    public static LeftTuple getFirstLeftTuple(LeftTupleMemory memory, FastIterator it) {
        if (!memory.isIndexed()) {
            return memory.getFirst(null);
        }
        return (LeftTuple)it.next(null);
    }

    public BetaNodeFieldConstraint[] getConstraints() {
        return this.constraints.getConstraints();
    }

    public BetaConstraints getRawConstraints() {
        return this.constraints;
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        updateContext.startVisitNode(this.leftInput);
        this.rightInput.networkUpdated(updateContext);
        updateContext.endVisit();
        if (!updateContext.isVisiting(this.leftInput)) {
            this.leftInput.networkUpdated(updateContext);
        }
    }

    public List<String> getRules() {
        ArrayList<String> list = new ArrayList<String>();
        for (LeftTupleSink sinkleftTupleSink : this.sink.getSinks()) {
            if (sinkleftTupleSink instanceof RuleTerminalNode) {
                list.add(((RuleTerminalNode)sinkleftTupleSink).getRule().getName());
                continue;
            }
            if (!(sinkleftTupleSink instanceof BetaNode)) continue;
            list.addAll(((BetaNode)sinkleftTupleSink).getRules());
        }
        return list;
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        if (this.objectTypeNode == null) {
            ObjectSource source = this.rightInput;
            while (source != null) {
                if (source instanceof ObjectTypeNode) {
                    this.objectTypeNode = (ObjectTypeNode)source;
                    break;
                }
                source = source.source;
            }
        }
        return this.objectTypeNode;
    }

    @Override
    public void attach(BuildContext context) {
        this.constraints.init(context, this.getType());
        this.setUnificationJoin();
        this.rightInput.addObjectSink(this);
        this.leftInput.addTupleSink(this, context);
    }

    @Override
    public void updateSinkOnAttach(BuildContext context, PropagationContext propagationContext, InternalWorkingMemory workingMemory) {
        boolean rightUpdate;
        boolean leftUpdate = !context.getNodes().contains(this.getLeftTupleSource());
        boolean bl = rightUpdate = this.getRightInput().getType() == 15 || !context.getNodes().contains(this.getRightInput());
        if (!this.lrUnlinkingEnabled && rightUpdate) {
            this.rightInput.updateSink(this, propagationContext, workingMemory);
        }
        if (leftUpdate) {
            this.leftInput.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse() || context.getCleanupAdapter() != null) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                Entry tmp;
                Memory object = workingMemory.getNodeMemory(this);
                BetaMemory memory = object instanceof AccumulateNode.AccumulateMemory ? ((AccumulateNode.AccumulateMemory)object).betaMemory : (BetaMemory)object;
                FastIterator it = memory.getLeftTupleMemory().fullFastIterator();
                LeftTuple leftTuple = BetaNode.getFirstLeftTuple(memory.getLeftTupleMemory(), it);
                while (leftTuple != null) {
                    tmp = (LeftTuple)it.next(leftTuple);
                    if (context.getCleanupAdapter() != null) {
                        LeftTuple child;
                        while ((child = leftTuple.getFirstChild()) != null) {
                            if (child.getLeftTupleSink() == this) {
                                child.unlinkFromLeftParent();
                                child.unlinkFromRightParent();
                                continue;
                            }
                            context.getCleanupAdapter().cleanUp(child, workingMemory);
                        }
                    }
                    memory.getLeftTupleMemory().remove(leftTuple);
                    leftTuple.unlinkFromLeftParent();
                    leftTuple.unlinkFromRightParent();
                    leftTuple = tmp;
                }
                if (object instanceof AccumulateNode.AccumulateMemory) {
                    ((AccumulateNode)this).doRemove(workingMemory, (AccumulateNode.AccumulateMemory)object);
                }
                if (this.isInUse()) continue;
                it = memory.getRightTupleMemory().fullFastIterator();
                Entry rightTuple = BetaNode.getFirstRightTuple(memory.getRightTupleMemory(), it);
                while (rightTuple != null) {
                    tmp = (RightTuple)it.next(rightTuple);
                    if (rightTuple.getBlocked() != null) {
                        LeftTuple leftTuple2 = rightTuple.getBlocked();
                        while (leftTuple2 != null) {
                            LeftTuple temp = leftTuple2.getBlockedNext();
                            leftTuple2.setBlocker(null);
                            leftTuple2.setBlockedPrevious(null);
                            leftTuple2.setBlockedNext(null);
                            leftTuple2.unlinkFromLeftParent();
                            leftTuple2 = temp;
                        }
                    }
                    memory.getRightTupleMemory().remove((RightTuple)rightTuple);
                    rightTuple.unlinkFromRightParent();
                    rightTuple = tmp;
                }
                workingMemory.clearNodeMemory(this);
            }
            context.setCleanupAdapter(null);
        }
        if (!this.isInUse()) {
            this.leftInput.removeTupleSink(this);
            this.rightInput.removeObjectSink(this);
        }
    }

    @Override
    protected void doCollectAncestors(NodeSet nodeSet) {
        this.leftInput.collectAncestors(nodeSet);
        this.rightInput.collectAncestors(nodeSet);
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple rightTuple = modifyPreviousTuples.peekRightTuple();
        while (rightTuple != null && rightTuple.getRightTupleSink().getRightInputOtnId().before(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple();
            rightTuple.getRightTupleSink().retractRightTuple(rightTuple, context, workingMemory);
            rightTuple = modifyPreviousTuples.peekRightTuple();
        }
        if (rightTuple != null && rightTuple.getRightTupleSink().getRightInputOtnId().equals(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple();
            rightTuple.reAdd();
            if (BitMaskUtil.intersect(context.getModificationMask(), this.rightInferredMask)) {
                this.modifyRightTuple(rightTuple, context, workingMemory);
            }
        } else if (BitMaskUtil.intersect(context.getModificationMask(), this.rightInferredMask)) {
            this.assertObject(factHandle, context, workingMemory);
        }
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemory;
    }

    public void setObjectMemoryEnabled(boolean objectMemory) {
        this.objectMemory = objectMemory;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public boolean isConcurrentRightTupleMemory() {
        return this.concurrentRightTupleMemory;
    }

    public void setConcurrentRightTupleMemory(boolean concurrentRightTupleMemory) {
        this.concurrentRightTupleMemory = concurrentRightTupleMemory;
    }

    @Override
    public String toString() {
        return "[ " + this.getClass().getSimpleName() + "(" + this.id + ") ]";
    }

    public void dumpMemory(InternalWorkingMemory workingMemory) {
        MemoryVisitor visitor = new MemoryVisitor(workingMemory);
        visitor.visit(this);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.leftInput;
    }

    @Override
    public int hashCode() {
        int hash = 23 * this.leftInput.hashCode() + 29 * this.rightInput.hashCode() + 31 * this.constraints.hashCode();
        if (this.leftListenedProperties != null) {
            hash += 37 * ((Object)this.leftListenedProperties).hashCode();
        }
        if (this.rightListenedProperties != null) {
            hash += 41 * ((Object)this.rightListenedProperties).hashCode();
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof BetaNode)) {
            return false;
        }
        BetaNode other = (BetaNode)object;
        return this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints) && ClassUtils.areNullSafeEquals(this.leftListenedProperties, other.leftListenedProperties) && ClassUtils.areNullSafeEquals(this.rightListenedProperties, other.rightListenedProperties);
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config) {
        return this.constraints.createBetaMemory(config, this.getType());
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }

    public RightTuple createRightTuple(InternalFactHandle handle, RightTupleSink sink, PropagationContext context) {
        if (!this.concurrentRightTupleMemory) {
            WindowTupleList list = context.getActiveWindowTupleList();
            if (list == null) {
                return new RightTuple(handle, sink);
            }
            return new WindowTuple(handle, sink, list);
        }
        return new ConcurrentRightTuple(handle, sink);
    }

    protected boolean leftUnlinked(PropagationContext context, InternalWorkingMemory workingMemory, BetaMemory memory) {
        if (memory.isLeftUnlinked()) {
            return true;
        }
        if (memory.isRightUnlinked()) {
            memory.linkRight();
            context.setShouldPropagateAll(this);
            this.rightInput.updateSink(this, context, workingMemory);
        }
        return false;
    }

    protected boolean rightUnlinked(PropagationContext context, InternalWorkingMemory workingMemory, BetaMemory memory) {
        if (memory.isRightUnlinked()) {
            return true;
        }
        if (memory.isLeftUnlinked()) {
            memory.linkLeft();
            context.setShouldPropagateAll(this);
            this.leftInput.updateSink(this, context, workingMemory);
        }
        return false;
    }

    public long getRightDeclaredMask() {
        return this.rightDeclaredMask;
    }

    public void setRightDeclaredMask(long rightDeclaredMask) {
        this.rightDeclaredMask = rightDeclaredMask;
    }

    public long getRightInferredMask() {
        return this.rightInferredMask;
    }

    public long getRightNegativeMask() {
        return this.rightNegativeMask;
    }

    @Override
    public ObjectTypeNode.Id getRightInputOtnId() {
        return this.rightInputOtnId;
    }

    public void setRightInputOtnId(ObjectTypeNode.Id rightInputOtnId) {
        this.rightInputOtnId = rightInputOtnId;
    }

    public ObjectSource getRightInput() {
        return this.rightInput;
    }
}

