/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;

final class TrimInstruction
extends TemplateElement {
    private final int TYPE_T = 0;
    private final int TYPE_LT = 1;
    private final int TYPE_RT = 2;
    private final int TYPE_NT = 3;
    final boolean left;
    final boolean right;

    TrimInstruction(boolean left, boolean right) {
        this.left = left;
        this.right = right;
    }

    TemplateElement[] accept(Environment env) {
        return null;
    }

    protected String dump(boolean canonical) {
        StringBuilder sb = new StringBuilder();
        if (canonical) {
            sb.append('<');
        }
        sb.append(this.getNodeTypeSymbol());
        if (canonical) {
            sb.append("/>");
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        if (this.left && this.right) {
            return "#t";
        }
        if (this.left) {
            return "#lt";
        }
        if (this.right) {
            return "#rt";
        }
        return "#nt";
    }

    boolean isIgnorable(boolean stripWhitespace) {
        return true;
    }

    int getParameterCount() {
        return 1;
    }

    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        int type = this.left && this.right ? 0 : (this.left ? 1 : (this.right ? 2 : 3));
        return type;
    }

    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.AST_NODE_SUBTYPE;
    }

    boolean isOutputCacheable() {
        return true;
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

