/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.Serializable;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Random;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.security.CredentialsImpl;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.IdentityImpl;
import org.jboss.seam.security.RunAsOperation;
import org.jboss.seam.security.TokenStore;
import org.jboss.seam.security.events.QuietLoginEvent;
import org.jboss.seam.security.util.Base64;
import org.picketlink.idm.api.Role;

@Named
@SessionScoped
public class RememberMe
implements Serializable {
    private static final long serialVersionUID = 2242379431576068199L;
    @Inject
    BeanManager manager;
    @Inject
    Identity identity;
    @Inject
    IdentityImpl identityImpl;
    @Inject
    CredentialsImpl credentials;
    private TokenStore tokenStore;
    private boolean enabled;
    private boolean autoLoggedIn;
    private Random random = new Random(System.currentTimeMillis());
    private Mode mode = Mode.usernameOnly;

    public void quietLogin(@Observes QuietLoginEvent event) {
        if (this.mode.equals((Object)Mode.autoLogin) && this.isEnabled()) {
            String username = this.credentials.getUsername();
            BoolWrapper userEnabled = new BoolWrapper();
            ArrayList roles = new ArrayList();
            if (this.tokenStore.validateToken(username, this.credentials.getPassword())) {
                this.identityImpl.runAs(new RunAsOperation(true){

                    @Override
                    public void execute() {
                    }
                });
                if (userEnabled.value) {
                    this.identityImpl.unAuthenticate();
                    this.identityImpl.preAuthenticate();
                    for (Role role : roles) {
                        this.identity.addRole(role.getRoleType().getName(), role.getGroup().getName(), role.getGroup().getGroupType());
                    }
                    this.identityImpl.postAuthenticate();
                    this.autoLoggedIn = true;
                }
            }
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public boolean isAutoLoggedIn() {
        return this.autoLoggedIn;
    }

    protected String generateTokenValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(new UID().toString());
        sb.append(":");
        sb.append(this.random.nextLong());
        return sb.toString();
    }

    protected String encodeToken(String username, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(username);
        sb.append(":");
        sb.append(value);
        return Base64.encodeBytes(sb.toString().getBytes());
    }

    private class BoolWrapper {
        boolean value;

        private BoolWrapper() {
        }
    }

    public static enum Mode {
        disabled,
        usernameOnly,
        autoLogin;

    }
}

