/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.model;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.drools.template.model.DRLElement;
import org.drools.template.model.DRLOutput;

public abstract class AttributedDRLElement
extends DRLElement {
    private Map<String, String> _attr2value = new HashMap<String, String>();

    protected AttributedDRLElement() {
    }

    protected AttributedDRLElement(Integer salience) {
        if (salience != null) {
            this._attr2value.put("salience", Integer.toString(salience));
        }
    }

    protected void renderDRL(DRLOutput out) {
        for (Map.Entry<String, String> entry : this._attr2value.entrySet()) {
            String attribute = entry.getKey();
            String value = entry.getValue();
            out.writeLine("\t" + attribute + " " + value);
        }
    }

    protected String asStringLiteral(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") && value.length() >= 2) {
            value = value.substring(1, value.length() - 1);
        }
        return '\"' + value.replaceAll("\"", Matcher.quoteReplacement("\\\"")) + '\"';
    }

    protected String asTimerLiteral(String value) {
        if (value.startsWith("(") && value.endsWith(")") && value.length() >= 2) {
            value = value.substring(1, value.length() - 1);
        }
        return "(" + value + ")";
    }

    public void setSalience(Integer value) {
        this._attr2value.put("salience", Integer.toString(value));
    }

    public void setSalience(String value) {
        this._attr2value.put("salience", value);
    }

    public void setDuration(Long value) {
        this._attr2value.put("duration", Long.toString(value));
    }

    public void setTimer(String value) {
        this._attr2value.put("timer", this.asTimerLiteral(value));
    }

    public void setCalendars(String value) {
        this._attr2value.put("calendars", this.asStringLiteral(value));
    }

    public void setActivationGroup(String value) {
        this._attr2value.put("activation-group", this.asStringLiteral(value));
    }

    public void setRuleFlowGroup(String value) {
        this._attr2value.put("ruleflow-group", this.asStringLiteral(value));
    }

    public void setAgendaGroup(String value) {
        this._attr2value.put("agenda-group", this.asStringLiteral(value));
    }

    public void setNoLoop(boolean value) {
        this._attr2value.put("no-loop", Boolean.toString(value));
    }

    public void setLockOnActive(boolean value) {
        this._attr2value.put("lock-on-active", Boolean.toString(value));
    }

    public void setAutoFocus(boolean value) {
        this._attr2value.put("auto-focus", Boolean.toString(value));
    }

    public String getAttribute(String name) {
        return this._attr2value.get(name).toString();
    }

    public String getSalience() {
        return this._attr2value.get("salience");
    }
}

