/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.guvnor.common.services.project.model.Project;
import org.kie.api.builder.KieModule;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.backend.builder.LRUBuilderCache;
import org.kie.workbench.common.services.backend.builder.LRUProjectDependenciesClassLoaderCache;
import org.kie.workbench.common.services.backend.project.MapClassLoader;
import org.kie.workbench.common.services.shared.project.KieProject;

@ApplicationScoped
public class ProjectClassLoaderHelper {
    @Inject
    private LRUBuilderCache builderCache;
    @Inject
    @Named(value="LRUProjectDependenciesClassLoaderCache")
    private LRUProjectDependenciesClassLoaderCache dependenciesClassLoaderCache;

    public ClassLoader getProjectClassLoader(KieProject project) {
        ClassLoader projectClassLoader;
        KieModule module = this.builderCache.assertBuilder((Project)project).getKieModuleIgnoringErrors();
        ClassLoader dependenciesClassLoader = this.dependenciesClassLoaderCache.assertDependenciesClassLoader(project);
        if (module instanceof InternalKieModule) {
            InternalKieModule internalModule = (InternalKieModule)module;
            projectClassLoader = new MapClassLoader(internalModule.getClassesMap(true), dependenciesClassLoader);
        } else {
            projectClassLoader = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)module).getClassLoader();
        }
        return projectClassLoader;
    }
}

