/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation.asset;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.services.backend.validation.asset.ValidatorBuildService;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class DefaultGenericKieValidator
implements GenericValidator {
    private ValidatorBuildService validatorBuildService;

    public DefaultGenericKieValidator() {
    }

    @Inject
    public DefaultGenericKieValidator(ValidatorBuildService validatorBuildService) {
        this.validatorBuildService = validatorBuildService;
    }

    public List<ValidationMessage> validate(Path path, String content) {
        return this.validatorBuildService.validate(path, content).stream().filter(this.fromValidatedPath(path)).collect(Collectors.toList());
    }

    public List<ValidationMessage> validate(Path path) {
        return this.validatorBuildService.validate(path).stream().filter(this.fromValidatedPath(path)).collect(Collectors.toList());
    }

    protected Predicate<ValidationMessage> fromValidatedPath(Path path) {
        return message -> {
            String destinationPathURI = this.removeFileExtension(path.toURI());
            String messageURI = message.getPath() != null ? this.removeFileExtension(message.getPath().toURI()) : "";
            return messageURI.isEmpty() || destinationPathURI.endsWith(messageURI);
        };
    }

    private String removeFileExtension(String pathURI) {
        if (pathURI != null && pathURI.contains(".")) {
            return pathURI.substring(0, pathURI.lastIndexOf("."));
        }
        return pathURI;
    }
}

