/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;

abstract class TreeNodeList
extends AbstractList<TreeTable.Node>
implements CheckedContainer<TreeTable.Node>,
Serializable {
    private static final long serialVersionUID = -8723469207489667631L;
    protected static final int NULL = 0;
    protected static final int THIS = 1;
    protected static final int DRY_RUN = 2;
    protected final TreeTable.Node parent;
    private TreeTable.Node[] children;
    private int size;

    protected TreeNodeList(TreeTable.Node node) {
        this.parent = node;
    }

    private boolean isParentOf(TreeTable.Node node) throws IllegalArgumentException {
        if (node == this.parent) {
            throw new IllegalArgumentException(Errors.format((short)73, node));
        }
        TreeTable.Node node2 = node.getParent();
        if (node2 == null) {
            return false;
        }
        if (node2 == this.parent) {
            return true;
        }
        throw new IllegalArgumentException(Errors.format((short)74, node));
    }

    protected abstract void setParentOf(TreeTable.Node var1, int var2) throws IllegalArgumentException;

    @Override
    public final Class<TreeTable.Node> getElementType() {
        return TreeTable.Node.class;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public TreeTable.Node get(int n) {
        ArgumentChecks.ensureValidIndex(this.size, n);
        return this.children[n];
    }

    @Override
    public TreeTable.Node set(int n, TreeTable.Node node) throws IllegalArgumentException {
        ArgumentChecks.ensureValidIndex(this.size, n);
        ArgumentChecks.ensureNonNull("node", node);
        TreeTable.Node node2 = this.children[n];
        if (node2 != node) {
            if (this.isParentOf(node)) {
                this.ensureNotPresent(node);
                this.setParentOf(node2, 0);
            } else {
                this.setParentOf(node, 2);
                this.setParentOf(node2, 0);
                this.setParentOf(node, 1);
            }
            this.children[n] = node;
            ++this.modCount;
        }
        return node2;
    }

    @Override
    public void add(int n, TreeTable.Node node) throws IllegalArgumentException {
        ArgumentChecks.ensureValidIndex(this.size + 1, n);
        ArgumentChecks.ensureNonNull("node", node);
        if (this.isParentOf(node)) {
            this.ensureNotPresent(node);
        } else {
            this.setParentOf(node, 1);
        }
        this.addChild(n, node);
    }

    final void addChild(int n, TreeTable.Node node) {
        if (this.children == null) {
            this.children = new TreeTable.Node[4];
        } else if (this.size == this.children.length) {
            this.children = Arrays.copyOf(this.children, this.size * 2);
        }
        System.arraycopy(this.children, n, this.children, n + 1, this.size - n);
        this.children[n] = node;
        ++this.size;
        ++this.modCount;
    }

    private void ensureNotPresent(TreeTable.Node node) throws IllegalArgumentException {
        int n = this.size;
        while (--n >= 0) {
            if (this.children[n] != node) continue;
            throw new IllegalArgumentException(Errors.format((short)19));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeRange(int n, int n2) throws IllegalArgumentException {
        int n3;
        try {
            for (n3 = n2; n3 != n; --n3) {
                this.setParentOf(this.children[n3 - 1], 0);
            }
        }
        finally {
            ++this.modCount;
            System.arraycopy(this.children, n2, this.children, n3, this.size - n2);
            Arrays.fill(this.children, n2, this.size, null);
            this.size -= n2 - n3;
        }
    }

    @Override
    public final TreeTable.Node remove(int n) throws IllegalArgumentException {
        ArgumentChecks.ensureValidIndex(this.size, n);
        TreeTable.Node node = this.children[n];
        this.setParentOf(node, 0);
        System.arraycopy(this.children, n + 1, this.children, n, --this.size - n);
        this.children[this.size] = null;
        ++this.modCount;
        return node;
    }

    @Override
    public boolean remove(Object object) throws IllegalArgumentException {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    @Override
    public final boolean contains(Object object) {
        return object instanceof TreeTable.Node && ((TreeTable.Node)object).getParent() == this.parent;
    }

    @Override
    public final int indexOf(Object object) {
        return this.lastIndexOf(object);
    }

    @Override
    public final int lastIndexOf(Object object) {
        if (this.contains(object)) {
            int n = this.size;
            while (--n >= 0) {
                if (this.children[n] != object) continue;
                return n;
            }
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.children, this.size);
    }
}

