/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.definitions.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.TypeResolver;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.GlobalImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.traits.TraitRegistry;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.rule.DialectRuntimeRegistry;
import org.drools.core.rule.Function;
import org.drools.core.rule.ImportDeclaration;
import org.drools.core.rule.InvalidRulePackage;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.WindowDeclaration;
import org.drools.core.ruleunit.RuleUnitRegistry;
import org.drools.core.util.ClassUtils;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.rule.Global;
import org.kie.api.definition.rule.Query;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.internal.io.ResourceTypePackage;

public class KnowledgePackageImpl
implements InternalKnowledgePackage,
Externalizable {
    private static final long serialVersionUID = 510L;
    private String name;
    private Map<String, RuleImpl> rules;
    private Map<String, ImportDeclaration> imports;
    private Map<String, Function> functions;
    private Map<String, AccumulateFunction> accumulateFunctions;
    private Set<String> staticImports;
    private Map<String, String> globals;
    private Map<String, FactTemplate> factTemplates;
    private Map<String, Process> ruleFlows;
    private DialectRuntimeRegistry dialectRuntimeRegistry;
    private LinkedHashMap<String, TypeDeclaration> typeDeclarations;
    private Set<String> entryPointsIds = Collections.emptySet();
    private Map<String, WindowDeclaration> windowDeclarations;
    private ClassFieldAccessorStore classFieldAccessorStore;
    private TraitRegistry traitRegistry;
    private Map<ResourceType, ResourceTypePackage> resourceTypePackages;
    private boolean valid = true;
    private boolean needStreamMode = false;
    private String errorSummary;
    private transient TypeResolver typeResolver;
    private transient RuleUnitRegistry ruleUnitRegistry;
    private transient AtomicBoolean inUse = new AtomicBoolean(false);

    public KnowledgePackageImpl() {
        this(null);
    }

    public KnowledgePackageImpl(String name) {
        this.name = name;
        this.imports = new HashMap<String, ImportDeclaration>();
        this.accumulateFunctions = Collections.emptyMap();
        this.typeDeclarations = new LinkedHashMap();
        this.staticImports = Collections.emptySet();
        this.rules = new LinkedHashMap<String, RuleImpl>();
        this.ruleFlows = Collections.emptyMap();
        this.globals = Collections.emptyMap();
        this.factTemplates = Collections.emptyMap();
        this.functions = Collections.emptyMap();
        this.dialectRuntimeRegistry = new DialectRuntimeRegistry();
        this.classFieldAccessorStore = new ClassFieldAccessorStore();
        this.entryPointsIds = Collections.emptySet();
        this.windowDeclarations = Collections.emptyMap();
        this.resourceTypePackages = Collections.emptyMap();
    }

    @Override
    public Map<ResourceType, ResourceTypePackage> getResourceTypePackages() {
        if (this.resourceTypePackages == Collections.EMPTY_MAP) {
            this.resourceTypePackages = new HashMap<ResourceType, ResourceTypePackage>();
        }
        return this.resourceTypePackages;
    }

    public Collection<Rule> getRules() {
        ArrayList<RuleImpl> list = new ArrayList<RuleImpl>(this.rules.size());
        for (RuleImpl rule : this.rules.values()) {
            list.add(rule);
        }
        return Collections.unmodifiableCollection(list);
    }

    public Function getFunction(String name) {
        return this.functions.containsKey(name) ? this.functions.get(name) : null;
    }

    public Collection<Process> getProcesses() {
        Collection<Process> processes = this.getRuleFlows().values();
        ArrayList<Process> list = new ArrayList<Process>(processes.size());
        for (Process process : processes) {
            list.add(process);
        }
        return Collections.unmodifiableCollection(list);
    }

    public Collection<FactType> getFactTypes() {
        if (this.typeDeclarations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClassDefinition> list = new ArrayList<ClassDefinition>();
        for (TypeDeclaration typeDeclaration : this.typeDeclarations.values()) {
            list.add(typeDeclaration.getTypeClassDef());
        }
        return Collections.unmodifiableCollection(list);
    }

    public Map<String, FactType> getFactTypesMap() {
        HashMap<String, FactType> types = new HashMap<String, FactType>();
        for (Map.Entry<String, TypeDeclaration> entry : this.typeDeclarations.entrySet()) {
            types.put(entry.getKey(), entry.getValue().getTypeClassDef());
        }
        return types;
    }

    public Collection<Query> getQueries() {
        ArrayList<RuleImpl> list = new ArrayList<RuleImpl>(this.rules.size());
        for (RuleImpl rule : this.rules.values()) {
            if (!rule.isQuery()) continue;
            list.add(rule);
        }
        return Collections.unmodifiableCollection(list);
    }

    public Collection<String> getFunctionNames() {
        return Collections.unmodifiableCollection(this.functions.keySet());
    }

    public Collection<Global> getGlobalVariables() {
        ArrayList<GlobalImpl> list = new ArrayList<GlobalImpl>(this.getGlobals().size());
        for (Map.Entry<String, String> global : this.getGlobals().entrySet()) {
            list.add(new GlobalImpl(global.getKey(), global.getValue()));
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        ObjectOutput out;
        boolean isDroolsStream = stream instanceof DroolsObjectOutputStream;
        ByteArrayOutputStream bytes = null;
        if (isDroolsStream) {
            out = stream;
        } else {
            bytes = new ByteArrayOutputStream();
            out = new DroolsObjectOutputStream(bytes);
        }
        out.writeObject(this.dialectRuntimeRegistry);
        out.writeObject(this.typeDeclarations);
        out.writeObject(this.name);
        out.writeObject(this.imports);
        out.writeObject(this.staticImports);
        out.writeObject(this.functions);
        out.writeObject(this.accumulateFunctions);
        out.writeObject(this.factTemplates);
        out.writeObject(this.ruleFlows);
        out.writeObject(this.globals);
        out.writeBoolean(this.valid);
        out.writeBoolean(this.needStreamMode);
        out.writeObject(this.rules);
        out.writeObject(this.classFieldAccessorStore);
        out.writeObject(this.entryPointsIds);
        out.writeObject(this.windowDeclarations);
        out.writeObject(this.traitRegistry);
        if (!isDroolsStream) {
            bytes.flush();
            bytes.close();
            stream.writeObject(bytes.toByteArray());
        }
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        boolean isDroolsStream = stream instanceof DroolsObjectInputStream;
        DroolsObjectInputStream in = isDroolsStream ? (DroolsObjectInputStream)stream : new DroolsObjectInputStream(new ByteArrayInputStream((byte[])stream.readObject()));
        this.dialectRuntimeRegistry = (DialectRuntimeRegistry)in.readObject();
        this.typeDeclarations = (LinkedHashMap)in.readObject();
        this.name = (String)in.readObject();
        this.imports = (Map)in.readObject();
        this.staticImports = (Set)in.readObject();
        this.functions = (Map)in.readObject();
        this.accumulateFunctions = (Map)in.readObject();
        this.factTemplates = (Map)in.readObject();
        this.ruleFlows = (Map)in.readObject();
        this.globals = (Map)in.readObject();
        this.valid = in.readBoolean();
        this.needStreamMode = in.readBoolean();
        this.rules = (Map)in.readObject();
        this.classFieldAccessorStore = (ClassFieldAccessorStore)in.readObject();
        this.entryPointsIds = (Set)in.readObject();
        this.windowDeclarations = (Map)in.readObject();
        this.traitRegistry = (TraitRegistry)in.readObject();
        if (!isDroolsStream) {
            in.close();
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ClassLoader getPackageClassLoader() {
        JavaDialectRuntimeData javaRuntime = (JavaDialectRuntimeData)this.getDialectRuntimeRegistry().getDialectData("java");
        return javaRuntime.getClassLoader();
    }

    @Override
    public DialectRuntimeRegistry getDialectRuntimeRegistry() {
        return this.dialectRuntimeRegistry;
    }

    @Override
    public void setDialectRuntimeRegistry(DialectRuntimeRegistry dialectRuntimeRegistry) {
        this.dialectRuntimeRegistry = dialectRuntimeRegistry;
    }

    @Override
    public void addImport(ImportDeclaration importDecl) {
        this.imports.put(importDecl.getTarget(), importDecl);
    }

    public void removeImport(String importEntry) {
        this.imports.remove(importEntry);
    }

    @Override
    public Map<String, ImportDeclaration> getImports() {
        return this.imports;
    }

    @Override
    public void addTypeDeclaration(TypeDeclaration typeDecl) {
        this.typeDeclarations.put(typeDecl.getTypeName(), typeDecl);
    }

    public void removeTypeDeclaration(String type) {
        this.typeDeclarations.remove(type);
    }

    @Override
    public Map<String, TypeDeclaration> getTypeDeclarations() {
        return this.typeDeclarations;
    }

    @Override
    public TypeDeclaration getTypeDeclaration(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        TypeDeclaration typeDeclaration = this.getTypeDeclaration(clazz.getSimpleName());
        if (typeDeclaration == null) {
            for (TypeDeclaration type : this.typeDeclarations.values()) {
                if (!type.isValid() || !type.matches(clazz)) continue;
                typeDeclaration = type;
                break;
            }
        }
        return typeDeclaration;
    }

    @Override
    public TypeDeclaration getTypeDeclaration(String type) {
        return this.typeDeclarations.get(type);
    }

    @Override
    public void addStaticImport(String functionImport) {
        if (this.staticImports == Collections.EMPTY_SET) {
            this.staticImports = new HashSet<String>(2);
        }
        this.staticImports.add(functionImport);
    }

    @Override
    public void addFunction(Function function) {
        if (this.functions == Collections.EMPTY_MAP) {
            this.functions = new HashMap<String, Function>(1);
        }
        this.functions.put(function.getName(), function);
        this.dialectRuntimeRegistry.getDialectData(function.getDialect()).setDirty(true);
    }

    @Override
    public Map<String, Function> getFunctions() {
        return this.functions;
    }

    @Override
    public void addAccumulateFunction(String name, AccumulateFunction function) {
        if (this.accumulateFunctions == Collections.EMPTY_MAP) {
            this.accumulateFunctions = new HashMap<String, AccumulateFunction>(1);
        }
        this.accumulateFunctions.put(name, function);
    }

    @Override
    public Map<String, AccumulateFunction> getAccumulateFunctions() {
        return this.accumulateFunctions;
    }

    public void removeFunctionImport(String functionImport) {
        this.staticImports.remove(functionImport);
    }

    @Override
    public Set<String> getStaticImports() {
        return this.staticImports;
    }

    @Override
    public void addGlobal(String identifier, Class<?> clazz) {
        if (this.globals == Collections.EMPTY_MAP) {
            this.globals = new HashMap<String, String>(1);
        }
        this.globals.put(identifier, clazz.getName());
    }

    @Override
    public void removeGlobal(String identifier) {
        this.globals.remove(identifier);
    }

    @Override
    public Map<String, String> getGlobals() {
        return this.globals;
    }

    @Override
    public void removeFunction(String functionName) {
        Function function = this.functions.remove(functionName);
        if (function != null) {
            this.dialectRuntimeRegistry.removeFunction(this, function);
        }
    }

    @Override
    public FactTemplate getFactTemplate(String name) {
        return this.factTemplates.get(name);
    }

    @Override
    public void addFactTemplate(FactTemplate factTemplate) {
        if (this.factTemplates == Collections.EMPTY_MAP) {
            this.factTemplates = new HashMap<String, FactTemplate>(1);
        }
        this.factTemplates.put(factTemplate.getName(), factTemplate);
    }

    @Override
    public void addRule(RuleImpl rule) {
        this.rules.put(rule.getName(), rule);
    }

    @Override
    public void addProcess(Process process) {
        if (this.ruleFlows == Collections.EMPTY_MAP) {
            this.ruleFlows = new HashMap<String, Process>();
        }
        this.ruleFlows.put(process.getId(), process);
    }

    @Override
    public Map<String, Process> getRuleFlows() {
        return this.ruleFlows;
    }

    @Override
    public void removeRuleFlow(String id) {
        if (!this.ruleFlows.containsKey(id)) {
            throw new IllegalArgumentException("The rule flow with id [" + id + "] is not part of this package.");
        }
        this.ruleFlows.remove(id);
    }

    @Override
    public void removeRule(RuleImpl rule) {
        this.rules.remove(rule.getName());
        this.dialectRuntimeRegistry.removeRule(this, rule);
    }

    @Override
    public RuleImpl getRule(String name) {
        return this.rules.get(name);
    }

    public String toString() {
        return "[Package name=" + this.name + "]";
    }

    @Override
    public void setError(String summary) {
        this.errorSummary = summary;
        this.valid = false;
    }

    @Override
    public void resetErrors() {
        this.errorSummary = "";
        this.valid = true;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void checkValidity() {
        if (!this.isValid()) {
            throw new InvalidRulePackage(this.getErrorSummary());
        }
    }

    public String getErrorSummary() {
        return this.errorSummary;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof KnowledgePackageImpl)) {
            return false;
        }
        KnowledgePackageImpl other = (KnowledgePackageImpl)object;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void clear() {
        this.rules.clear();
        this.dialectRuntimeRegistry.clear();
        this.ruleFlows.clear();
        this.imports.clear();
        this.functions.clear();
        this.accumulateFunctions.clear();
        this.staticImports.clear();
        this.globals.clear();
        this.factTemplates.clear();
        this.typeDeclarations.clear();
        this.windowDeclarations.clear();
    }

    @Override
    public FactType getFactType(String typeName) {
        if (typeName == null || this.name != null && !typeName.startsWith(this.name + ".")) {
            return null;
        }
        String key = this.name == null ? typeName : typeName.substring(this.name.length() + 1);
        TypeDeclaration decl = this.typeDeclarations.get(key);
        if (decl == null) {
            return null;
        }
        if (decl.isDefinition()) {
            return decl.getTypeClassDef();
        }
        throw new UnsupportedOperationException("KieBase.getFactType should only be used to retrieve declared beans. Class " + typeName + " exists outside DRL ");
    }

    @Override
    public ClassFieldAccessorStore getClassFieldAccessorStore() {
        return this.classFieldAccessorStore;
    }

    @Override
    public void setClassFieldAccessorCache(ClassFieldAccessorCache classFieldAccessorCache) {
        this.classFieldAccessorStore.setClassFieldAccessorCache(classFieldAccessorCache);
    }

    @Override
    public Set<String> getEntryPointIds() {
        return this.entryPointsIds;
    }

    @Override
    public void addEntryPointId(String id) {
        if (this.entryPointsIds == Collections.EMPTY_SET) {
            this.entryPointsIds = new HashSet<String>();
        }
        this.entryPointsIds.add(id);
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public void setTypeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
        this.ruleUnitRegistry = new RuleUnitRegistry(typeResolver);
    }

    @Override
    public RuleUnitRegistry getRuleUnitRegistry() {
        return this.ruleUnitRegistry;
    }

    @Override
    public void addWindowDeclaration(WindowDeclaration window) {
        if (this.windowDeclarations == Collections.EMPTY_MAP) {
            this.windowDeclarations = new HashMap<String, WindowDeclaration>();
        }
        this.windowDeclarations.put(window.getName(), window);
    }

    @Override
    public Map<String, WindowDeclaration> getWindowDeclarations() {
        return this.windowDeclarations;
    }

    public void setWindowDeclarations(Map<String, WindowDeclaration> windowDeclarations) {
        this.windowDeclarations = windowDeclarations;
    }

    @Override
    public boolean hasTraitRegistry() {
        return this.traitRegistry != null;
    }

    @Override
    public TraitRegistry getTraitRegistry() {
        if (this.traitRegistry == null) {
            this.traitRegistry = new TraitRegistry();
        }
        return this.traitRegistry;
    }

    @Override
    public boolean removeObjectsGeneratedFromResource(Resource resource) {
        List<RuleImpl> rulesToBeRemoved = this.removeRulesGeneratedFromResource(resource);
        List<TypeDeclaration> typesToBeRemoved = this.removeTypesGeneratedFromResource(resource);
        List<Function> functionsToBeRemoved = this.removeFunctionsGeneratedFromResource(resource);
        List<Process> processesToBeRemoved = this.removeProcessesGeneratedFromResource(resource);
        return !rulesToBeRemoved.isEmpty() || !typesToBeRemoved.isEmpty() || !functionsToBeRemoved.isEmpty() || !processesToBeRemoved.isEmpty();
    }

    @Override
    public List<TypeDeclaration> removeTypesGeneratedFromResource(Resource resource) {
        List<TypeDeclaration> typesToBeRemoved = this.getTypesGeneratedFromResource(resource);
        if (!typesToBeRemoved.isEmpty()) {
            JavaDialectRuntimeData dialect = (JavaDialectRuntimeData)this.getDialectRuntimeRegistry().getDialectData("java");
            for (TypeDeclaration type : typesToBeRemoved) {
                if (type.getTypeClassName() != null) {
                    this.classFieldAccessorStore.removeType(type);
                    dialect.remove(type.getTypeClassName());
                }
                this.removeTypeDeclaration(type.getTypeName());
            }
            dialect.reload();
        }
        return typesToBeRemoved;
    }

    @Override
    public List<RuleImpl> removeRulesGeneratedFromResource(Resource resource) {
        List<RuleImpl> rulesToBeRemoved = this.getRulesGeneratedFromResource(resource);
        for (RuleImpl rule : rulesToBeRemoved) {
            this.removeRule(rule);
        }
        return rulesToBeRemoved;
    }

    private List<RuleImpl> getRulesGeneratedFromResource(Resource resource) {
        ArrayList<RuleImpl> rulesFromResource = new ArrayList<RuleImpl>();
        for (RuleImpl rule : this.rules.values()) {
            if (!resource.equals(rule.getResource())) continue;
            rulesFromResource.add(rule);
        }
        return rulesFromResource;
    }

    private List<TypeDeclaration> getTypesGeneratedFromResource(Resource resource) {
        ArrayList<TypeDeclaration> typesFromResource = new ArrayList<TypeDeclaration>();
        for (TypeDeclaration type : this.typeDeclarations.values()) {
            if (!resource.equals(type.getResource())) continue;
            typesFromResource.add(type);
        }
        return typesFromResource;
    }

    @Override
    public List<Function> removeFunctionsGeneratedFromResource(Resource resource) {
        List<Function> functionsToBeRemoved = this.getFunctionsGeneratedFromResource(resource);
        for (Function function : functionsToBeRemoved) {
            this.removeFunction(function.getName());
        }
        return functionsToBeRemoved;
    }

    private List<Function> getFunctionsGeneratedFromResource(Resource resource) {
        ArrayList<Function> functionsFromResource = new ArrayList<Function>();
        for (Function function : this.functions.values()) {
            if (!resource.equals(function.getResource())) continue;
            functionsFromResource.add(function);
        }
        return functionsFromResource;
    }

    @Override
    public List<Process> removeProcessesGeneratedFromResource(Resource resource) {
        List<Process> processesToBeRemoved = this.getProcessesGeneratedFromResource(resource);
        for (Process process : processesToBeRemoved) {
            this.removeProcess(process);
        }
        return processesToBeRemoved;
    }

    private void removeProcess(Process process) {
        this.ruleFlows.remove(process.getId());
    }

    private List<Process> getProcessesGeneratedFromResource(Resource resource) {
        ArrayList<Process> processesFromResource = new ArrayList<Process>();
        for (Process process : this.ruleFlows.values()) {
            if (!resource.equals(process.getResource())) continue;
            processesFromResource.add(process);
        }
        return processesFromResource;
    }

    public boolean needsStreamMode() {
        return this.needStreamMode;
    }

    @Override
    public void setNeedStreamMode() {
        this.needStreamMode = true;
    }

    @Override
    public KnowledgePackageImpl deepCloneIfAlreadyInUse(ClassLoader classLoader) {
        ClassLoader originalClassLoader;
        if (this.inUse.compareAndSet(false, true)) {
            return this;
        }
        if (classLoader instanceof ProjectClassLoader && (originalClassLoader = ((JavaDialectRuntimeData)this.dialectRuntimeRegistry.getDialectData("java")).getRootClassLoader()) instanceof ProjectClassLoader) {
            ((ProjectClassLoader)classLoader).initFrom((ProjectClassLoader)originalClassLoader);
        }
        return ClassUtils.deepClone(this, classLoader);
    }
}

