/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.DynamicEntryPoint;
import org.drools.core.common.InternalAgenda;
import org.drools.core.datasources.CursoredDataSource;
import org.drools.core.datasources.InternalDataSource;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.event.RuleRuntimeEventSupport;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.InternalRuleUnitExecutor;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.rule.EntryPointId;
import org.drools.core.ruleunit.RuleUnitDescr;
import org.drools.core.ruleunit.RuleUnitFactory;
import org.drools.core.ruleunit.RuleUnitGuardSystem;
import org.drools.core.ruleunit.RuleUnitsNodeMemories;
import org.drools.core.spi.Activation;
import org.drools.core.spi.FactHandleFactory;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.rule.DataSource;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.api.runtime.rule.RuleUnitExecutor;

public class RuleUnitExecutorSession
implements InternalRuleUnitExecutor {
    private final StatefulKnowledgeSessionImpl session;
    private RuleUnitGuardSystem ruleUnitGuardSystem;
    private RuleUnitFactory ruleUnitFactory;
    private RuleUnit currentRuleUnit;
    private AtomicBoolean suspended = new AtomicBoolean(false);

    public RuleUnitExecutorSession() {
        this.session = new StatefulKnowledgeSessionImpl();
        this.initSession();
        this.session.agendaEventSupport = new AgendaEventSupport();
        this.session.ruleRuntimeEventSupport = new RuleRuntimeEventSupport();
    }

    public RuleUnitExecutorSession(long id, boolean initInitFactHandle, SessionConfiguration config, Environment environment) {
        this.session = new StatefulKnowledgeSessionImpl(id, null, initInitFactHandle, config, environment);
        this.initSession();
    }

    public RuleUnitExecutorSession(long id, FactHandleFactory handleFactory, long propagationContext, SessionConfiguration config, InternalAgenda agenda, Environment environment) {
        this.session = new StatefulKnowledgeSessionImpl(id, null, handleFactory, propagationContext, config, agenda, environment);
        this.initSession();
    }

    private void initSession() {
        this.session.init();
        this.session.ruleUnitExecutor = this;
    }

    public RuleUnitExecutor bind(KieBase kiebase) {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)kiebase;
        if (!kbase.hasUnits()) {
            throw new IllegalStateException("Cannot create a RuleUnitExecutor against a KieBase without units");
        }
        this.session.handleFactory = kbase.newFactHandleFactory();
        this.session.bindRuleBase(kbase, null, false, false);
        this.session.nodeMemories = new RuleUnitsNodeMemories(kbase);
        DynamicEntryPoint defaultEp = new DynamicEntryPoint(EntryPointId.DEFAULT, this.session);
        this.session.defaultEntryPoint = defaultEp;
        defaultEp.bindRuleBase(kbase);
        this.ruleUnitGuardSystem = new RuleUnitGuardSystem(this);
        return this;
    }

    public <T> DataSource<T> newDataSource(String name, T ... items) {
        CursoredDataSource dataSource = new CursoredDataSource(this.session);
        for (T item : items) {
            dataSource.insert(item);
        }
        this.getRuleUnitFactory().bindVariable(name, dataSource);
        return dataSource;
    }

    public int run(Class<? extends RuleUnit> ruleUnitClass) {
        return this.internalRun(this.getRuleUnitFactory().getOrCreateRuleUnit(ruleUnitClass));
    }

    public int run(RuleUnit ruleUnit) {
        return this.internalRun(this.getRuleUnitFactory().injectUnitVariables(ruleUnit));
    }

    private int internalRun(RuleUnit ruleUnit) {
        return this.internalExecuteUnit(ruleUnit) + this.ruleUnitGuardSystem.fireActiveUnits(ruleUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int internalExecuteUnit(RuleUnit ruleUnit) {
        RuleUnitDescr ruDescr = this.bindRuleUnit(ruleUnit);
        try {
            int n = this.session.fireAllRules();
            return n;
        }
        finally {
            this.unbindRuleUnit(ruDescr);
        }
    }

    public void runUntilHalt(Class<? extends RuleUnit> ruleUnitClass) {
        this.runUntilHalt(this.getRuleUnitFactory().getOrCreateRuleUnit(ruleUnitClass));
    }

    public void runUntilHalt(RuleUnit ruleUnit) {
        this.bindRuleUnit(ruleUnit);
        this.session.fireUntilHalt();
    }

    public void halt() {
        this.session.halt();
        this.unbindRuleUnit(this.session.kBase.getRuleUnitRegistry().getRuleUnitDescr(this.currentRuleUnit));
    }

    @Override
    public RuleUnitDescr switchToRuleUnit(Class<? extends RuleUnit> ruleUnitClass) {
        return this.switchToRuleUnit(this.getRuleUnitFactory().getOrCreateRuleUnit(ruleUnitClass));
    }

    @Override
    public RuleUnitDescr switchToRuleUnit(RuleUnit ruleUnit) {
        if (this.currentRuleUnit != null) {
            this.currentRuleUnit.onYield(ruleUnit);
        }
        this.session.getPropagationList().flush();
        return this.bindRuleUnit(ruleUnit);
    }

    @Override
    public void guardRuleUnit(Class<? extends RuleUnit> ruleUnitClass, Activation activation) {
        this.ruleUnitGuardSystem.registerGuard(this.getRuleUnitFactory().getOrCreateRuleUnit(ruleUnitClass), activation);
    }

    @Override
    public void guardRuleUnit(RuleUnit ruleUnit, Activation activation) {
        this.ruleUnitGuardSystem.registerGuard(this.getRuleUnitFactory().registerUnit(ruleUnit), activation);
    }

    @Override
    public void cancelActivation(Activation activation) {
        this.ruleUnitGuardSystem.removeActivation(activation);
    }

    private RuleUnitDescr bindRuleUnit(RuleUnit ruleUnit) {
        this.suspended.set(false);
        this.currentRuleUnit = ruleUnit;
        this.currentRuleUnit.onStart();
        this.getNodeMemories().bindRuleUnit(this.session, ruleUnit);
        RuleUnitDescr ruDescr = this.session.kBase.getRuleUnitRegistry().getRuleUnitDescr(ruleUnit);
        ruDescr.bindDataSources(this.session, ruleUnit);
        ((Globals)this.session.getGlobalResolver()).setDelegate((Globals)new RuleUnitGlobals(ruDescr, ruleUnit));
        return ruDescr;
    }

    private void unbindRuleUnit(RuleUnitDescr ruDescr) {
        this.getNodeMemories().unbindRuleUnit();
        ruDescr.unbindDataSources(this.session, this.currentRuleUnit);
        ((Globals)this.session.getGlobalResolver()).setDelegate(null);
        this.currentRuleUnit.onEnd();
        this.currentRuleUnit = null;
        this.suspended.set(true);
    }

    private RuleUnitsNodeMemories getNodeMemories() {
        return (RuleUnitsNodeMemories)this.session.nodeMemories;
    }

    @Override
    public RuleUnit getCurrentRuleUnit() {
        return this.currentRuleUnit;
    }

    public RuleUnitFactory getRuleUnitFactory() {
        if (this.ruleUnitFactory == null) {
            this.ruleUnitFactory = new RuleUnitFactory();
        }
        return this.ruleUnitFactory;
    }

    public RuleUnitExecutor bindVariable(String name, Object value) {
        this.getRuleUnitFactory().bindVariable(name, value);
        if (value instanceof InternalDataSource) {
            ((InternalDataSource)value).setWorkingMemory(this.session);
        }
        return this;
    }

    @Override
    public void onSuspend() {
        if (!this.suspended.getAndSet(true) && this.currentRuleUnit != null) {
            this.currentRuleUnit.onSuspend();
        }
    }

    @Override
    public void onResume() {
        if (this.suspended.getAndSet(false) && this.currentRuleUnit != null) {
            this.currentRuleUnit.onResume();
        }
    }

    public void dispose() {
        this.session.dispose();
        this.ruleUnitGuardSystem = null;
        this.ruleUnitFactory = null;
        this.currentRuleUnit = null;
    }

    public static class RuleUnitGlobals
    implements Globals {
        private final RuleUnitDescr ruDescr;
        private final RuleUnit ruleUnit;

        private RuleUnitGlobals(RuleUnitDescr ruDescr, RuleUnit ruleUnit) {
            this.ruDescr = ruDescr;
            this.ruleUnit = ruleUnit;
        }

        public Object get(String identifier) {
            return this.ruDescr.getValue(this.ruleUnit, identifier);
        }

        public void set(String identifier, Object value) {
            throw new UnsupportedOperationException();
        }

        public void setDelegate(Globals delegate) {
            throw new UnsupportedOperationException();
        }

        public Collection<String> getGlobalKeys() {
            throw new UnsupportedOperationException();
        }
    }
}

