/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.builder.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.model.GAV;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class IncrementalBuildResults {
    private GAV gav;
    private ArrayList<BuildMessage> addedMessages = new ArrayList();
    private ArrayList<BuildMessage> removedMessages = new ArrayList();

    public IncrementalBuildResults() {
    }

    public IncrementalBuildResults(GAV gav) {
        this.gav = gav;
    }

    public GAV getGAV() {
        return this.gav;
    }

    public List<BuildMessage> getAddedMessages() {
        return Collections.unmodifiableList(this.addedMessages);
    }

    public List<BuildMessage> getRemovedMessages() {
        return Collections.unmodifiableList(this.removedMessages);
    }

    public void addAddedMessage(BuildMessage message) {
        this.addedMessages.add(message);
    }

    public void addRemovedMessage(BuildMessage message) {
        this.removedMessages.add(message);
    }

    public void addAllAddedMessages(List<BuildMessage> buildMessages) {
        this.addedMessages.addAll(buildMessages);
    }

    public void addAllRemovedMessages(List<BuildMessage> buildMessages) {
        this.removedMessages.addAll(buildMessages);
    }
}

