/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.model;

import java.util.HashSet;
import java.util.Set;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.commons.validation.PortablePreconditions;

@Portable
public class ProjectRepositories {
    private Set<ProjectRepository> repositories;

    public ProjectRepositories() {
        this.repositories = new HashSet<ProjectRepository>();
    }

    public ProjectRepositories(@MapsTo(value="repositories") Set<ProjectRepository> repositories) {
        this.repositories = repositories;
    }

    public Set<ProjectRepository> getRepositories() {
        return this.repositories;
    }

    public MavenRepositoryMetadata[] filterByIncluded() {
        HashSet<MavenRepositoryMetadata> filter = new HashSet<MavenRepositoryMetadata>();
        for (ProjectRepository pr : this.repositories) {
            if (!pr.isIncluded()) continue;
            filter.add(pr.getMetadata());
        }
        MavenRepositoryMetadata[] aFilter = new MavenRepositoryMetadata[filter.size()];
        filter.toArray(aFilter);
        return aFilter;
    }

    @Portable
    public static class ProjectRepository {
        private boolean include;
        private MavenRepositoryMetadata metadata;

        public ProjectRepository(@MapsTo(value="include") boolean include, @MapsTo(value="metadata") MavenRepositoryMetadata metadata) {
            this.include = include;
            this.metadata = (MavenRepositoryMetadata)PortablePreconditions.checkNotNull((String)"metadata", (Object)metadata);
        }

        public boolean isIncluded() {
            return this.include;
        }

        public void setIncluded(boolean include) {
            this.include = include;
        }

        public MavenRepositoryMetadata getMetadata() {
            return this.metadata;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ProjectRepository)) {
                return false;
            }
            ProjectRepository that = (ProjectRepository)o;
            if (this.include != that.include) {
                return false;
            }
            return this.metadata.equals(that.metadata);
        }

        public int hashCode() {
            int result = this.include ? 1 : 0;
            result = 31 * result + this.metadata.hashCode();
            result = ~(~result);
            return result;
        }
    }
}

