/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.NodeContainer;
import org.drools.definition.process.Process;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.jbpm.bpmn2.core.DataStore;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.bpmn2.core.Error;
import org.jbpm.bpmn2.core.Escalation;
import org.jbpm.bpmn2.core.Interface;
import org.jbpm.bpmn2.core.IntermediateLink;
import org.jbpm.bpmn2.core.ItemDefinition;
import org.jbpm.bpmn2.core.Lane;
import org.jbpm.bpmn2.core.Message;
import org.jbpm.bpmn2.core.SequenceFlow;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.exception.ActionExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.process.core.context.swimlane.Swimlane;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.impl.CancelNodeInstanceAction;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.impl.ConstraintImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.jbpm.workflow.core.node.StateNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessHandler
extends BaseAbstractHandler
implements Handler {
    public static final String CONNECTIONS = "BPMN.Connections";
    public static final String LINKS = "BPMN.ThrowLinks";

    public ProcessHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Definitions.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(ItemDefinition.class);
            this.validPeers.add(Message.class);
            this.validPeers.add(Interface.class);
            this.validPeers.add(Escalation.class);
            this.validPeers.add(Error.class);
            this.validPeers.add(DataStore.class);
            this.validPeers.add(RuleFlowProcess.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String name = attrs.getValue("name");
        String packageName = attrs.getValue("http://www.jboss.org/drools", "packageName");
        String dynamic = attrs.getValue("http://www.jboss.org/drools", "adHoc");
        String version = attrs.getValue("http://www.jboss.org/drools", "version");
        RuleFlowProcess process = new RuleFlowProcess();
        process.setAutoComplete(true);
        process.setId(id);
        if (name == null) {
            name = id;
        }
        process.setName(name);
        process.setType("RuleFlow");
        if (packageName == null) {
            packageName = "org.drools.bpmn2";
        }
        process.setPackageName(packageName);
        if ("true".equals(dynamic)) {
            process.setDynamic(true);
            process.setAutoComplete(false);
        }
        if (version != null) {
            process.setVersion(version);
        }
        ((ProcessBuildData)parser.getData()).addProcess((Process)process);
        process.setMetaData("Definitions", parser.getParent());
        Object typedImports = ((ProcessBuildData)parser.getData()).getMetaData("Bpmn2Imports");
        if (typedImports != null) {
            process.setMetaData("Bpmn2Imports", typedImports);
        }
        return process;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        RuleFlowProcess process = (RuleFlowProcess)parser.getCurrent();
        List throwLinks = (List)process.getMetaData(LINKS);
        ProcessHandler.linkIntermediateLinks((NodeContainer)process, throwLinks);
        List connections = (List)process.getMetaData(CONNECTIONS);
        ProcessHandler.linkConnections((NodeContainer)process, connections);
        ProcessHandler.linkBoundaryEvents((NodeContainer)process);
        List lanes = (List)process.getMetaData("BPMN.Lanes");
        this.assignLanes(process, lanes);
        this.postProcessNodes((NodeContainer)process);
        return process;
    }

    public static void linkIntermediateLinks(NodeContainer process, List<IntermediateLink> links) {
        if (null != links) {
            ArrayList<IntermediateLink> throwLinks = new ArrayList<IntermediateLink>();
            for (IntermediateLink aLinks : links) {
                if (!aLinks.isThrowLink()) continue;
                throwLinks.add(aLinks);
            }
            for (IntermediateLink throwLink : throwLinks) {
                ArrayList<IntermediateLink> linksWithSharedNames = new ArrayList<IntermediateLink>();
                for (IntermediateLink aLink : links) {
                    if (!throwLink.getName().equals(aLink.getName())) continue;
                    linksWithSharedNames.add(aLink);
                }
                if (linksWithSharedNames.size() < 2) {
                    throw new IllegalArgumentException("There should be at least 2 link events to make a connection");
                }
                linksWithSharedNames.remove(throwLink);
                Node t = ProcessHandler.findNodeByIdOrUniqueIdInMetadata(process, throwLink.getUniqueId());
                for (IntermediateLink catchLink : linksWithSharedNames) {
                    Node c = ProcessHandler.findNodeByIdOrUniqueIdInMetadata(process, catchLink.getUniqueId());
                    if (t == null || c == null) continue;
                    ConnectionImpl result = new ConnectionImpl(t, "DROOLS_DEFAULT", c, "DROOLS_DEFAULT");
                    result.setMetaData("linkNodeHidden", (Object)"yes");
                }
                links.remove(throwLink);
                links.removeAll(linksWithSharedNames);
            }
            if (links.size() > 0) {
                throw new IllegalArgumentException(links.size() + " links were not processed");
            }
        }
    }

    private static Node findNodeByIdOrUniqueIdInMetadata(NodeContainer nodeContainer, String targetRef) {
        try {
            String targetId = targetRef.substring(1);
            targetId = targetId.substring(targetId.lastIndexOf("-") + 1);
            return nodeContainer.getNode((long)new Integer(targetId).intValue());
        }
        catch (NumberFormatException e) {
            Node targetNode = null;
            for (Node node : nodeContainer.getNodes()) {
                if (!targetRef.equals(node.getMetaData().get("UniqueId"))) continue;
                targetNode = node;
                break;
            }
            if (targetNode != null) {
                return targetNode;
            }
            throw new IllegalArgumentException("Could not find target node for connection:" + targetRef);
        }
    }

    public Class<?> generateNodeFor() {
        return RuleFlowProcess.class;
    }

    public static void linkConnections(NodeContainer nodeContainer, List<SequenceFlow> connections) {
        if (connections != null) {
            for (SequenceFlow connection : connections) {
                Node target;
                Node source;
                block10: {
                    String targetRef;
                    block9: {
                        String sourceRef = connection.getSourceRef();
                        targetRef = connection.getTargetRef();
                        source = null;
                        target = null;
                        try {
                            sourceRef = sourceRef.substring(1);
                            sourceRef = sourceRef.substring(sourceRef.lastIndexOf("-") + 1);
                            source = nodeContainer.getNode((long)new Integer(sourceRef).intValue());
                        }
                        catch (NumberFormatException e) {
                            for (Node node : nodeContainer.getNodes()) {
                                if (!connection.getSourceRef().equals(node.getMetaData().get("UniqueId"))) continue;
                                source = node;
                                break;
                            }
                            if (source != null) break block9;
                            throw new IllegalArgumentException("Could not find source node for connection:" + connection.getSourceRef());
                        }
                    }
                    try {
                        targetRef = targetRef.substring(1);
                        targetRef = targetRef.substring(targetRef.lastIndexOf("-") + 1);
                        target = nodeContainer.getNode((long)new Integer(targetRef).intValue());
                    }
                    catch (NumberFormatException e) {
                        for (Node node : nodeContainer.getNodes()) {
                            if (!connection.getTargetRef().equals(node.getMetaData().get("UniqueId"))) continue;
                            target = node;
                            break;
                        }
                        if (target != null) break block10;
                        throw new IllegalArgumentException("Could not find target node for connection:" + connection.getTargetRef());
                    }
                }
                ConnectionImpl result = new ConnectionImpl(source, "DROOLS_DEFAULT", target, "DROOLS_DEFAULT");
                result.setMetaData("bendpoints", (Object)connection.getBendpoints());
                result.setMetaData("UniqueId", (Object)connection.getId());
                if (System.getProperty("jbpm.enable.multi.con") != null) {
                    NodeImpl nodeImpl = (NodeImpl)source;
                    Constraint constraint = ProcessHandler.buildConstraint(connection, nodeImpl);
                    if (constraint == null) continue;
                    nodeImpl.addConstraint(new ConnectionRef(target.getId(), "DROOLS_DEFAULT"), constraint);
                    continue;
                }
                if (!(source instanceof Split)) continue;
                Split split = (Split)source;
                Constraint constraint = ProcessHandler.buildConstraint(connection, (NodeImpl)split);
                split.addConstraint(new ConnectionRef(target.getId(), "DROOLS_DEFAULT"), constraint);
            }
        }
    }

    public static void linkBoundaryEvents(NodeContainer nodeContainer) {
        for (Node node : nodeContainer.getNodes()) {
            String eventType;
            DroolsConsequenceAction action;
            Node attachedNode;
            String type;
            String attachedTo;
            block25: {
                if (!(node instanceof EventNode) || (attachedTo = (String)node.getMetaData().get("AttachedTo")) == null) continue;
                type = ((EventTypeFilter)((EventNode)node).getEventFilters().get(0)).getType();
                attachedNode = null;
                try {
                    String attachedToString = attachedTo.substring(1);
                    attachedToString = attachedToString.substring(attachedToString.lastIndexOf("-") + 1);
                    attachedNode = nodeContainer.getNode((long)new Integer(attachedToString).intValue());
                }
                catch (NumberFormatException e) {
                    for (Node subnode : nodeContainer.getNodes()) {
                        if (!attachedTo.equals(subnode.getMetaData().get("UniqueId"))) continue;
                        attachedNode = subnode;
                        break;
                    }
                    if (attachedNode != null) break block25;
                    throw new IllegalArgumentException("Could not find node to attach to: " + attachedTo);
                }
            }
            if (!(attachedNode instanceof StateBasedNode) && !type.startsWith("Compensate-")) {
                throw new IllegalArgumentException("Boundary events are supported only on StateBasedNode, found node: " + attachedNode.getClass().getName());
            }
            if (type.startsWith("Escalation-")) {
                boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
                String escalationCode = (String)node.getMetaData().get("EscalationEvent");
                ContextContainer compositeNode = (ContextContainer)attachedNode;
                ExceptionScope exceptionScope = (ExceptionScope)compositeNode.getDefaultContext("ExceptionScope");
                if (exceptionScope == null) {
                    exceptionScope = new ExceptionScope();
                    compositeNode.addContext((Context)exceptionScope);
                    compositeNode.setDefaultContext((Context)exceptionScope);
                }
                ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
                DroolsConsequenceAction action2 = null;
                if (attachedNode instanceof CompositeContextNode) {
                    action2 = new DroolsConsequenceAction("java", (cancelActivity ? "((org.jbpm.workflow.instance.NodeInstance) kcontext.getNodeInstance()).cancel();" : "") + "kcontext.getProcessInstance().signalEvent(\"Escalation-" + attachedTo + "-" + escalationCode + "\", null);");
                } else {
                    long attachedToNodeId = attachedNode.getId();
                    action2 = new DroolsConsequenceAction("java", cancelActivity ? "org.drools.runtime.process.WorkflowProcessInstance pi = (org.drools.runtime.process.WorkflowProcessInstance) kcontext.getProcessInstance();long nodeInstanceId = -1;for (org.drools.runtime.process.NodeInstance nodeInstance : pi.getNodeInstances()) {   if (" + attachedToNodeId + " == nodeInstance.getNodeId()) {" + "       nodeInstanceId = nodeInstance.getId();" + "       break;" + "   }" + "}" + "    ((org.jbpm.workflow.instance.NodeInstance)((org.jbpm.workflow.instance.NodeInstanceContainer) context.getProcessInstance()).getNodeInstance(nodeInstanceId)).cancel();" + "kcontext.getProcessInstance().signalEvent(\"Escalation-" + attachedTo + "-" + escalationCode + "\", null);" : "kcontext.getProcessInstance().signalEvent(\"Escalation-" + attachedTo + "-" + escalationCode + "\", null);");
                }
                exceptionHandler.setAction((DroolsAction)action2);
                exceptionScope.setExceptionHandler(escalationCode, (ExceptionHandler)exceptionHandler);
                continue;
            }
            if (type.startsWith("Error-")) {
                ContextContainer compositeNode = (ContextContainer)attachedNode;
                ExceptionScope exceptionScope = (ExceptionScope)compositeNode.getDefaultContext("ExceptionScope");
                if (exceptionScope == null) {
                    exceptionScope = new ExceptionScope();
                    compositeNode.addContext((Context)exceptionScope);
                    compositeNode.setDefaultContext((Context)exceptionScope);
                }
                String errorCode = (String)node.getMetaData().get("ErrorEvent");
                ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
                action = null;
                if (attachedNode instanceof CompositeContextNode) {
                    action = new DroolsConsequenceAction("java", "((org.jbpm.workflow.instance.NodeInstance) kcontext.getNodeInstance()).cancel();kcontext.getProcessInstance().signalEvent(\"Error-" + attachedTo + "-" + errorCode + "\", null);");
                } else {
                    long attachedToNodeId = attachedNode.getId();
                    action = new DroolsConsequenceAction("java", "org.drools.runtime.process.WorkflowProcessInstance pi = (org.drools.runtime.process.WorkflowProcessInstance) kcontext.getProcessInstance();long nodeInstanceId = -1;for (org.drools.runtime.process.NodeInstance nodeInstance : pi.getNodeInstances()) {   if (" + attachedToNodeId + " == nodeInstance.getNodeId()) {" + "       nodeInstanceId = nodeInstance.getId();" + "       break;" + "   }" + "}" + "if (nodeInstanceId > -1) {((org.jbpm.workflow.instance.NodeInstance)((org.jbpm.workflow.instance.NodeInstanceContainer) kcontext.getProcessInstance()).getNodeInstance(nodeInstanceId)).cancel();}" + "kcontext.getProcessInstance().signalEvent(\"Error-" + attachedTo + "-" + errorCode + "\", null);");
                }
                exceptionHandler.setAction((DroolsAction)action);
                exceptionScope.setExceptionHandler(errorCode, (ExceptionHandler)exceptionHandler);
                continue;
            }
            if (type.startsWith("Timer-")) {
                boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
                StateBasedNode compositeNode = (StateBasedNode)attachedNode;
                String timeDuration = (String)node.getMetaData().get("TimeDuration");
                String timeCycle = (String)node.getMetaData().get("TimeCycle");
                Timer timer = new Timer();
                if (timeDuration != null) {
                    timer.setDelay(timeDuration);
                    compositeNode.addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", (cancelActivity ? "((org.jbpm.workflow.instance.NodeInstance) kcontext.getNodeInstance()).cancel();" : "") + "kcontext.getProcessInstance().signalEvent(\"Timer-" + attachedTo + "-" + timeDuration + "\", null);"));
                    continue;
                }
                if (timeCycle == null) continue;
                int index = timeCycle.indexOf("###");
                if (index != -1) {
                    String period = timeCycle.substring(index + 3);
                    timeCycle = timeCycle.substring(0, index);
                    timer.setPeriod(period);
                }
                timer.setDelay(timeCycle);
                compositeNode.addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", (cancelActivity ? "((org.jbpm.workflow.instance.NodeInstance) kcontext.getNodeInstance()).cancel();" : "") + "kcontext.getProcessInstance().signalEvent(\"Timer-" + attachedTo + "-" + timeCycle + (timer.getPeriod() == null ? "" : "###" + timer.getPeriod()) + "\", null);"));
                continue;
            }
            if (type.startsWith("Compensate-")) {
                String activityRef = (String)node.getMetaData().get("ActivityRef");
                if (activityRef == null) {
                    activityRef = attachedTo;
                }
                eventType = "Compensate-" + activityRef;
                ((EventTypeFilter)((EventNode)node).getEventFilters().get(0)).setType(eventType);
                continue;
            }
            if (node.getMetaData().get("SignalName") != null || type.startsWith("Message-")) {
                boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
                long attachedToNodeId = attachedNode.getId();
                if (cancelActivity) {
                    ArrayList<DroolsConsequenceAction> actions = ((EventNode)node).getActions("onExit");
                    if (actions == null) {
                        actions = new ArrayList<DroolsConsequenceAction>();
                    }
                    action = new DroolsConsequenceAction("java", null);
                    action.setMetaData("Action", (Object)new CancelNodeInstanceAction(Long.valueOf(attachedToNodeId)));
                    actions.add(action);
                    ((EventNode)node).setActions("onExit", actions);
                }
                long id = node.getId();
                StateBasedNode stateBasedNode = (StateBasedNode)attachedNode;
                ArrayList<DroolsConsequenceAction> actionsAttachedTo = stateBasedNode.getActions("onExit");
                if (actionsAttachedTo == null) {
                    actionsAttachedTo = new ArrayList<DroolsConsequenceAction>();
                }
                DroolsConsequenceAction actionAttachedTo = new DroolsConsequenceAction("java", "org.drools.definition.process.Node node = context.getNodeInstance().getNode().getNodeContainer().getNode(" + id + ");" + "if (node instanceof org.jbpm.workflow.core.node.EventNode) {" + " ((org.jbpm.workflow.core.node.EventNode)node).getEventFilters().clear();" + "((org.jbpm.workflow.core.node.EventNode)node).addEventFilter(new org.jbpm.process.core.event.EventFilter () " + "{public boolean acceptsEvent(String type, Object event) { return false;}});" + "}");
                actionsAttachedTo.add(actionAttachedTo);
                stateBasedNode.setActions("onExit", actionsAttachedTo);
                continue;
            }
            if (!type.startsWith("Condition-")) continue;
            String processId = ((RuleFlowProcess)nodeContainer).getId();
            eventType = "RuleFlowStateEvent-" + processId + "-" + ((EventNode)node).getUniqueId() + "-" + attachedTo;
            ((EventTypeFilter)((EventNode)node).getEventFilters().get(0)).setType(eventType);
            long attachedToNodeId = attachedNode.getId();
            boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
            if (cancelActivity) {
                ArrayList<DroolsConsequenceAction> actions = ((EventNode)node).getActions("onExit");
                if (actions == null) {
                    actions = new ArrayList<DroolsConsequenceAction>();
                }
                DroolsConsequenceAction action3 = new DroolsConsequenceAction("java", null);
                action3.setMetaData("Action", (Object)new CancelNodeInstanceAction(Long.valueOf(attachedToNodeId)));
                actions.add(action3);
                ((EventNode)node).setActions("onExit", actions);
            }
            long id = node.getId();
            StateBasedNode stateBasedNode = (StateBasedNode)attachedNode;
            ArrayList<DroolsConsequenceAction> actionsAttachedTo = stateBasedNode.getActions("onExit");
            if (actionsAttachedTo == null) {
                actionsAttachedTo = new ArrayList<DroolsConsequenceAction>();
            }
            DroolsConsequenceAction actionAttachedTo = new DroolsConsequenceAction("java", "org.drools.definition.process.Node node = context.getNodeInstance().getNode().getNodeContainer().getNode(" + id + ");" + "if (node instanceof org.jbpm.workflow.core.node.EventNode) {" + " ((org.jbpm.workflow.core.node.EventNode)node).getEventFilters().clear();" + "((org.jbpm.workflow.core.node.EventNode)node).addEventFilter(new org.jbpm.process.core.event.EventFilter () " + "{public boolean acceptsEvent(String type, Object event) { return false;}});" + "}");
            actionsAttachedTo.add(actionAttachedTo);
            stateBasedNode.setActions("onExit", actionsAttachedTo);
            stateBasedNode.addBoundaryEvents(eventType);
        }
    }

    private void assignLanes(RuleFlowProcess process, List<Lane> lanes) {
        ArrayList<String> laneNames = new ArrayList<String>();
        HashMap<String, String> laneMapping = new HashMap<String, String>();
        if (lanes != null) {
            for (Lane lane : lanes) {
                String name = lane.getName();
                if (name == null) continue;
                Swimlane swimlane = new Swimlane();
                swimlane.setName(name);
                process.getSwimlaneContext().addSwimlane(swimlane);
                laneNames.add(name);
                for (String flowElementRef : lane.getFlowElements()) {
                    laneMapping.put(flowElementRef, name);
                }
            }
        }
        this.assignLanes((NodeContainer)process, laneMapping);
    }

    private void postProcessNodes(NodeContainer container) {
        for (Node node : container.getNodes()) {
            if (node instanceof StateNode) {
                StateNode stateNode = (StateNode)node;
                String condition = (String)stateNode.getMetaData("Condition");
                ConstraintImpl constraint = new ConstraintImpl();
                constraint.setConstraint(condition);
                constraint.setType("rule");
                for (Connection connection : stateNode.getDefaultOutgoingConnections()) {
                    stateNode.setConstraint(connection, (Constraint)constraint);
                }
                continue;
            }
            if (!(node instanceof NodeContainer)) continue;
            this.postProcessNodes((NodeContainer)node);
        }
    }

    private void assignLanes(NodeContainer nodeContainer, Map<String, String> laneMapping) {
        for (Node node : nodeContainer.getNodes()) {
            String lane = null;
            String uniqueId = (String)node.getMetaData().get("UniqueId");
            lane = uniqueId != null ? laneMapping.get(uniqueId) : laneMapping.get(XmlBPMNProcessDumper.getUniqueNodeId(node));
            if (lane != null) {
                ((NodeImpl)node).setMetaData("Lane", (Object)lane);
                if (node instanceof HumanTaskNode) {
                    ((HumanTaskNode)node).setSwimlane(lane);
                }
            }
            if (!(node instanceof NodeContainer)) continue;
            this.assignLanes((NodeContainer)node, laneMapping);
        }
    }

    private static Constraint buildConstraint(SequenceFlow connection, NodeImpl node) {
        if (connection.getExpression() == null) {
            return null;
        }
        ConstraintImpl constraint = new ConstraintImpl();
        String defaultConnection = (String)node.getMetaData("Default");
        if (defaultConnection != null && defaultConnection.equals(connection.getId())) {
            constraint.setDefault(true);
        }
        if (connection.getName() != null) {
            constraint.setName(connection.getName());
        } else {
            constraint.setName("");
        }
        if (connection.getType() != null) {
            constraint.setType(connection.getType());
        } else {
            constraint.setType("code");
        }
        if (connection.getLanguage() != null) {
            constraint.setDialect(connection.getLanguage());
        }
        if (connection.getExpression() != null) {
            constraint.setConstraint(connection.getExpression());
        }
        constraint.setPriority(connection.getPriority());
        return constraint;
    }
}

