/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.uberfire.annotations.Customizable;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.PreferenceScopeTypes;
import org.uberfire.preferences.shared.PreferenceScopeValidator;
import org.uberfire.preferences.shared.impl.exception.InvalidPreferenceScopeException;

@ApplicationScoped
public class PreferenceScopeValidatorImpl
implements PreferenceScopeValidator {
    private PreferenceScopeTypes scopeTypes;
    private PreferenceScopeResolutionStrategy scopeResolutionStrategy;

    protected PreferenceScopeValidatorImpl() {
    }

    @Inject
    public PreferenceScopeValidatorImpl(@Customizable PreferenceScopeTypes scopeTypes, @Customizable PreferenceScopeResolutionStrategy scopeResolutionStrategy) {
        this.scopeTypes = scopeTypes;
        this.scopeResolutionStrategy = scopeResolutionStrategy;
    }

    @Override
    public void validate(PreferenceScope scope) throws InvalidPreferenceScopeException {
        if (scope == null) {
            throw new InvalidPreferenceScopeException("A root scope must not be null.");
        }
        for (PreferenceScope currentScope = scope; currentScope != null; currentScope = currentScope.childScope()) {
            String type = currentScope.type();
            String key = currentScope.key();
            if (!this.scopeTypes.typeRequiresKey(type) || !this.isEmpty(key)) continue;
            throw new InvalidPreferenceScopeException("The type " + type + " must be associated with a non empty key.");
        }
        if (!this.scopeResolutionStrategy.getInfo().order().contains(scope)) {
            throw new InvalidPreferenceScopeException("This scope is not defined in the scope hierarchy.");
        }
    }

    protected boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

