/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RefreshAssetEditorEvent;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.ShowMessageEvent;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.RefreshModuleEditorEvent;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.Asset;

public abstract class AssetAttachmentFileWidget
extends Composite
implements EditorWidget {
    protected static final ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private FormPanel form;
    private FormStyleLayout layout;
    protected final Asset asset;
    protected final ClientFactory clientFactory;
    protected final EventBus eventBus;

    public AssetAttachmentFileWidget(Asset asset, RuleViewer viewer, ClientFactory clientFactory, EventBus eventBus) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.asset = asset;
        this.initWidgets(asset.getUuid(), asset.getName());
        this.initAssetHandlers();
    }

    protected void initWidgets(final String uuid, String formName) {
        this.form = new FormPanel();
        this.form.setAction(GWT.getModuleBaseURL() + "asset");
        this.form.setEncoding("multipart/form-data");
        this.form.setMethod("post");
        FileUpload up = new FileUpload();
        up.setName("fileUploadElement");
        HorizontalPanel fields = new HorizontalPanel();
        fields.add((Widget)this.getHiddenField("attachmentUUID", uuid));
        Button ok = new Button(ConstantsCore.INSTANCE.Upload());
        fields.add((Widget)up);
        fields.add((Widget)ok);
        this.form.add((Widget)fields);
        this.layout = new FormStyleLayout(this.getIcon(), formName);
        if (!this.asset.isReadonly()) {
            this.layout.addAttribute(ConstantsCore.INSTANCE.UploadNewVersion(), (Widget)this.form);
        }
        Button dl = new Button(ConstantsCore.INSTANCE.Download());
        dl.setEnabled(this.asset.getVersionNumber() > 0L);
        dl.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.open((String)(GWT.getModuleBaseURL() + "asset?" + "attachmentUUID" + "=" + uuid), (String)"downloading", (String)"resizable=no,scrollbars=yes,status=no");
            }
        });
        this.layout.addAttribute(ConstantsCore.INSTANCE.DownloadCurrentVersion(), (Widget)dl);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AssetAttachmentFileWidget.this.showUploadingBusy();
                AssetAttachmentFileWidget.this.submitUpload();
            }
        });
        this.initWidget((Widget)this.layout);
        this.layout.setWidth("100%");
        this.setStyleName(this.getOverallStyleName());
    }

    public abstract Image getIcon();

    public abstract String getOverallStyleName();

    void initAssetHandlers() {
        this.form.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                LoadingPopup.close();
                if (AssetAttachmentFileWidget.this.asset.getFormat().equals("jar")) {
                    AssetAttachmentFileWidget.this.eventBus.fireEvent((GwtEvent)new RefreshModuleEditorEvent(AssetAttachmentFileWidget.this.asset.getUuid()));
                }
                if (event.getResults().indexOf("OK") > -1) {
                    AssetAttachmentFileWidget.this.eventBus.fireEvent((GwtEvent)new ShowMessageEvent(ConstantsCore.INSTANCE.FileWasUploadedSuccessfully(), ShowMessageEvent.MessageType.INFO));
                    AssetAttachmentFileWidget.this.eventBus.fireEvent((GwtEvent)new RefreshAssetEditorEvent(AssetAttachmentFileWidget.this.asset.getMetaData().getModuleName(), AssetAttachmentFileWidget.this.asset.getUuid()));
                } else {
                    ErrorPopup.showMessage(ConstantsCore.INSTANCE.UnableToUploadTheFile());
                }
            }
        });
    }

    protected void submitUpload() {
        this.form.submit();
    }

    protected void showUploadingBusy() {
        LoadingPopup.showMessage(ConstantsCore.INSTANCE.Uploading());
    }

    private TextBox getHiddenField(String name, String value) {
        TextBox t = new TextBox();
        t.setName(name);
        t.setText(value);
        t.setVisible(false);
        return t;
    }

    public void addSupplementaryWidget(Widget d) {
        this.layout.addRow(d);
    }
}

