/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.ruleflow;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.ruleflow.AttributableNode;
import org.drools.guvnor.client.asseteditor.ruleflow.RuleFlowBaseNode;
import org.drools.guvnor.client.resources.FlowImages;

public class HumanTaskNode
extends RuleFlowBaseNode
implements AttributableNode {
    private static FlowImages images = (FlowImages)GWT.create(FlowImages.class);
    private Map<String, String> attributes;

    @Override
    public RuleFlowBaseNode.Corners getCorners() {
        return RuleFlowBaseNode.Corners.ROUNDED;
    }

    @Override
    public ImageResource getImagePath() {
        return images.humanTask();
    }

    @Override
    public String getStyle() {
        return "yellow-ruleflow-node";
    }

    public void onClick(Widget arg0) {
        if (this.parametersForm != null) {
            this.parametersForm.clear();
            for (final String key : this.attributes.keySet()) {
                String value = this.attributes.get(key);
                final TextBox tb = new TextBox();
                tb.setWidth("300px");
                tb.setText(value);
                tb.addFocusHandler(new FocusHandler(){

                    public void onFocus(FocusEvent event) {
                        tb.selectAll();
                    }
                });
                tb.addBlurHandler(new BlurHandler(){

                    public void onBlur(BlurEvent event) {
                        HumanTaskNode.this.attributes.put(key, tb.getText());
                    }
                });
                this.parametersForm.addAttribute(key, (Widget)tb);
            }
        }
    }

    @Override
    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    @Override
    public Map<String, String> getParameters() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, String> map) {
        this.attributes = map;
    }
}

