/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.PopupTitleBar;

public abstract class Popup
extends PopupPanel {
    private boolean dragged = false;
    private int dragStartX;
    private int dragStartY;
    private Command afterShowEvent;
    private Command afterCloseEvent;
    private boolean fixedLocation = false;
    private PopupTitleBar titleBar;

    public Popup() {
        this.setGlassEnabled(true);
    }

    public void setAfterShow(Command afterShowEvent) {
        this.afterShowEvent = afterShowEvent;
    }

    public void setAfterCloseEvent(Command afterCloseEvent) {
        this.afterCloseEvent = afterCloseEvent;
    }

    public void show() {
        if (this.afterShowEvent != null) {
            this.afterShowEvent.execute();
        }
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.setHorizontalAlignment(VerticalPanel.ALIGN_RIGHT);
        this.titleBar = new PopupTitleBar(this.getTitle());
        this.titleBar.closeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Popup.this.hide();
                if (Popup.this.afterCloseEvent != null) {
                    Popup.this.afterCloseEvent.execute();
                }
            }
        });
        this.titleBar.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                Popup.this.dragged = true;
                Popup.this.dragStartX = event.getRelativeX((Element)Popup.this.getElement());
                Popup.this.dragStartY = event.getRelativeY((Element)Popup.this.getElement());
                DOM.setCapture((com.google.gwt.user.client.Element)Popup.this.titleBar.getElement());
            }
        });
        this.titleBar.addMouseMoveHandler(new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                if (Popup.this.dragged) {
                    Popup.this.setPopupPosition(event.getClientX() - Popup.this.dragStartX, event.getClientY() - Popup.this.dragStartY);
                }
            }
        });
        this.titleBar.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                Popup.this.dragged = false;
                DOM.releaseCapture((com.google.gwt.user.client.Element)Popup.this.titleBar.getElement());
            }
        });
        verticalPanel.add((Widget)this.titleBar);
        Widget content = this.getContent();
        content.setWidth("100%");
        verticalPanel.add(content);
        this.add((Widget)verticalPanel);
        this.add((Widget)this.createKeyListeningFocusPanel(verticalPanel));
        super.show();
        this.focusFirstWidget(content);
        if (!this.fixedLocation) {
            this.center();
        }
    }

    private FocusPanel createKeyListeningFocusPanel(VerticalPanel verticalPanel) {
        FocusPanel focusPanel = new FocusPanel((Widget)verticalPanel);
        focusPanel.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 27) {
                    Popup.this.hide();
                }
            }
        });
        focusPanel.setStyleName("");
        focusPanel.setFocus(true);
        focusPanel.setWidth("100%");
        return focusPanel;
    }

    private void focusFirstWidget(Widget content) {
        FormStyleLayout fsl;
        Widget ow;
        if (content instanceof FormStyleLayout && (ow = (fsl = (FormStyleLayout)content).getWidget()) instanceof HasWidgets) {
            this.focusFirstWidget((HasWidgets)ow);
        }
    }

    private boolean focusFirstWidget(HasWidgets container) {
        boolean bFocused = false;
        Iterator iw = container.iterator();
        while (!bFocused && iw.hasNext()) {
            Widget w = (Widget)iw.next();
            if (w instanceof HasWidgets) {
                bFocused = this.focusFirstWidget((HasWidgets)w);
                continue;
            }
            if (w instanceof Focusable) {
                ((Focusable)w).setFocus(true);
                bFocused = true;
                break;
            }
            if (!(w instanceof FocusWidget)) continue;
            ((FocusWidget)w).setFocus(true);
            bFocused = true;
            break;
        }
        return bFocused;
    }

    public void setPopupPosition(int left, int top) {
        super.setPopupPosition(left, top);
        if (left != 0 && top != 0) {
            this.fixedLocation = true;
        }
    }

    public int getClientHeight() {
        return this.getWidget().getOffsetHeight() - this.titleBar.getOffsetHeight();
    }

    public abstract Widget getContent();
}

