/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import java.util.Map;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.configurations.ApplicationPreferences;
import org.drools.guvnor.client.explorer.navigation.modules.Folder;
import org.drools.guvnor.client.explorer.navigation.modules.PackageHierarchicalView;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.CategoryService;
import org.drools.guvnor.client.rpc.CategoryServiceAsync;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.util.Util;

public class ExplorerNodeConfig {
    private static ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    public static final String CATEGORY_ID = "category";
    public static final String RECENT_EDITED_ID = "recentEdited";
    public static final String RECENT_VIEWED_ID = "recentViewed";
    public static final String INCOMING_ID = "incoming";
    public static final String TEST_SCENARIOS_ID = "testScenarios";
    public static final String TEST_SCENARIOS_ROOT_ID = "roottestScenarios";
    public static final String ANALYSIS_ID = "analysis";
    public static final String ANALYSIS_ROOT_ID = "rootanalysis";
    public static final String RULE_LIST_TABLE_ID = "rulelist";
    public static final String PACKAGEVIEW_LIST_TABLE_ID = "packageviewlist";
    public static final String PACKAGE_SNAPSHOTS = "packageSnapshots";

    public static void setupDeploymentTree(Tree tree, Map<TreeItem, String> itemWidgets) {
        TreeItem root = tree.addItem(Util.getHeader(images.chartOrganisation(), constants.PackageSnapshots()));
        root.setState(true);
        itemWidgets.put(root, PACKAGE_SNAPSHOTS);
        ExplorerNodeConfig.deploymentListPackages(root);
    }

    private static void deploymentListPackages(final TreeItem root) {
        ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        moduleService.listModules((AsyncCallback<Module[]>)new GenericCallback<Module[]>(){

            public void onSuccess(Module[] values) {
                PackageHierarchicalView ph = new PackageHierarchicalView();
                for (Module val : values) {
                    ph.addPackage(val);
                }
                for (Folder hf : ph.getRootFolder().getChildren()) {
                    ExplorerNodeConfig.buildDeploymentTree(root, hf);
                }
            }
        });
    }

    private static void buildDeploymentTree(TreeItem root, Folder fldr) {
        if (fldr.getPackageConfigData() != null) {
            TreeItem pkg = new TreeItem(Util.getHeader(images.snapshotSmall(), fldr.getPackageConfigData().getName()));
            pkg.setUserObject((Object)fldr.getPackageConfigData());
            pkg.addItem(new TreeItem(constants.PleaseWaitDotDotDot()));
            root.addItem(pkg);
        } else {
            TreeItem tn = new TreeItem(Util.getHeader(images.emptyPackage(), fldr.getFolderName()));
            root.addItem(tn);
            for (Folder c : fldr.getChildren()) {
                ExplorerNodeConfig.buildDeploymentTree(tn, c);
            }
        }
    }

    private static void doCategoryNode(TreeItem treeItem, String path, Map<TreeItem, String> itemWidgets) {
        ExplorerNodeConfig.infanticide(treeItem);
        CategoryServiceAsync categoryService = (CategoryServiceAsync)GWT.create(CategoryService.class);
        categoryService.loadChildCategories(path, ExplorerNodeConfig.createGenericCallbackForLoadChildCategories(treeItem, path, itemWidgets));
    }

    private static GenericCallback<String[]> createGenericCallbackForLoadChildCategories(final TreeItem treeItem, final String path, final Map<TreeItem, String> itemWidgets) {
        return new GenericCallback<String[]>(){

            public void onSuccess(String[] value) {
                if (value.length == 0) {
                    ExplorerNodeConfig.infanticide(treeItem);
                } else {
                    this.createChildNodes(treeItem, path, itemWidgets, value);
                }
            }

            private void createChildNodes(TreeItem treeItem2, String path2, Map<TreeItem, String> itemWidgets2, String[] value) {
                for (String current : value) {
                    TreeItem childNode = new TreeItem(Util.getHeader(images.categorySmall(), current));
                    String widgetId = "category-" + (path2.equals("/") ? current : path2 + "/" + current);
                    itemWidgets2.put(childNode, widgetId);
                    treeItem2.addItem(childNode);
                    childNode.addItem(new TreeItem(Util.getHeader(images.categorySmall(), constants.PleaseWaitDotDotDot())));
                    childNode.getTree().addOpenHandler(this.createOpenHandlerForTree(itemWidgets2, childNode));
                }
            }

            private OpenHandler<TreeItem> createOpenHandlerForTree(final Map<TreeItem, String> itemWidgets2, final TreeItem childNode) {
                return new OpenHandler<TreeItem>(){
                    boolean expanding = false;

                    public void onOpen(OpenEvent<TreeItem> event) {
                        if (!this.expanding && event.getTarget() == childNode) {
                            this.expanding = true;
                            String widgetID = (String)itemWidgets2.get(event.getTarget());
                            String path = widgetID.substring(widgetID.indexOf("-") + 1);
                            ExplorerNodeConfig.infanticide(childNode);
                            ExplorerNodeConfig.doCategoryNode(childNode, path, itemWidgets2);
                            this.expanding = false;
                        }
                    }
                };
            }
        };
    }

    private static void infanticide(TreeItem treeNode) {
        treeNode.removeItems();
    }

    public static Tree getQAStructure(Map<TreeItem, String> itemWidgets) {
        Tree tree = new Tree();
        tree.setAnimationEnabled(true);
        TreeItem scenarios = new TreeItem(Util.getHeader(images.testManager(), constants.TestScenariosInPackages()));
        scenarios.addItem(new TreeItem(constants.PleaseWaitDotDotDot()));
        tree.addItem(scenarios);
        itemWidgets.put(scenarios, TEST_SCENARIOS_ROOT_ID);
        TreeItem analysis = new TreeItem(Util.getHeader(images.analyze(), constants.Analysis()));
        analysis.addItem(new TreeItem(constants.PleaseWaitDotDotDot()));
        itemWidgets.put(analysis, ANALYSIS_ROOT_ID);
        if (ApplicationPreferences.showVerifier()) {
            tree.addItem(analysis);
        }
        return tree;
    }
}

