/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.browse;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsTreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.client.configurations.UserCapabilities;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.FindPlace;
import org.drools.guvnor.client.explorer.navigation.browse.BrowseTreeView;
import org.drools.guvnor.client.explorer.navigation.browse.CategoryPlace;
import org.drools.guvnor.client.explorer.navigation.browse.InboxPlace;
import org.drools.guvnor.client.explorer.navigation.browse.StatePlace;

public class BrowseTree
implements BrowseTreeView.Presenter {
    private final BrowseTreeView view;
    private final ClientFactory clientFactory;
    private final Map<IsTreeItem, String> categories = new HashMap<IsTreeItem, String>();
    private final List<IsTreeItem> states = new ArrayList<IsTreeItem>();
    private IsTreeItem incomingInboxTreeItem;
    private IsTreeItem findRootTreeItem;
    private IsTreeItem inboxRecentlyEditedTreeItem;
    private IsTreeItem inboxRecentlyViewedTreeItem;
    private IsTreeItem root;
    private IsTreeItem categoriesRootItem;

    public BrowseTree(ClientFactory clientFactory, EventBus eventBus) {
        this.view = clientFactory.getNavigationViewFactory().getBrowseTreeView();
        this.clientFactory = clientFactory;
        this.view.setPresenter(this);
        this.root = this.view.addRootTreeItem();
        this.addInbox();
        this.findRootTreeItem = this.view.addFind();
        if (this.canShowStates()) {
            IsTreeItem isTreeItem = this.view.addRootStateTreeItem();
        }
        this.addRootCategory();
    }

    private void addInbox() {
        this.incomingInboxTreeItem = this.view.addInboxIncomingTreeItem();
        this.inboxRecentlyEditedTreeItem = this.view.addInboxRecentEditedTreeItem();
        this.inboxRecentlyViewedTreeItem = this.view.addInboxRecentViewedTreeItem();
    }

    private boolean canShowStates() {
        return UserCapabilities.INSTANCE.hasCapability(Capability.SHOW_KNOWLEDGE_BASES_VIEW);
    }

    private void addRootCategory() {
        this.categoriesRootItem = this.view.addRootCategoryTreeItem();
        this.categories.put(this.categoriesRootItem, "/");
    }

    private void addCategoryItem(String categoryName, IsTreeItem treeItem) {
        IsTreeItem subItem = this.view.addTreeItem(treeItem, categoryName);
        String path = this.getItemPath(categoryName, this.categories.get(treeItem));
        this.categories.put(subItem, path);
    }

    private String getItemPath(String categoryName, String parentItemPath) {
        String path = this.isParentRoot(parentItemPath) ? parentItemPath + categoryName : parentItemPath + "/" + categoryName;
        return path;
    }

    private boolean isParentRoot(String parentItemPath) {
        return parentItemPath.equals("/");
    }

    private void addSubStatesToTreeItem() {
        this.view.removeStates();
        this.clientFactory.getRepositoryService().listStates((AsyncCallback<String[]>)new GenericCallback<String[]>(){

            public void onSuccess(String[] result) {
                for (String name : result) {
                    IsTreeItem item = BrowseTree.this.view.addStateItem(name);
                    BrowseTree.this.states.add(item);
                }
            }
        });
    }

    public BrowseTreeView getView() {
        return this.view;
    }

    @Override
    public void onTreeItemSelection(IsTreeItem selectedItem, String title) {
        if (this.states.contains(selectedItem)) {
            this.goTo(new StatePlace(title));
        } else if (this.categories.containsKey(selectedItem)) {
            this.goTo(new CategoryPlace(this.categories.get(selectedItem)));
        } else if (selectedItem.equals(this.incomingInboxTreeItem)) {
            this.goTo(new InboxPlace("incoming"));
        } else if (selectedItem.equals(this.inboxRecentlyEditedTreeItem)) {
            this.goTo(new InboxPlace("recentEdited"));
        } else if (selectedItem.equals(this.inboxRecentlyViewedTreeItem)) {
            this.goTo(new InboxPlace("recentViewed"));
        } else if (selectedItem.equals(this.findRootTreeItem)) {
            this.clientFactory.getPlaceController().goTo((Place)new FindPlace());
        }
    }

    private void goTo(Place newPlace) {
        this.clientFactory.getPlaceController().goTo(newPlace);
    }

    @Override
    public void onTreeItemOpen(IsTreeItem openedItem) {
        if (this.root.equals(openedItem)) {
            if (this.canShowStates()) {
                this.addSubStatesToTreeItem();
            }
            this.view.removeCategories(this.categoriesRootItem);
            this.loadCategories(this.categoriesRootItem);
        } else if (this.categories.containsKey(openedItem)) {
            Collection<IsTreeItem> children = this.view.getChildren(openedItem);
            for (IsTreeItem child : children) {
                this.view.removeCategories(child);
                this.loadCategories(child);
            }
        }
    }

    private void loadCategories(final IsTreeItem treeItem) {
        String path = this.categories.get(treeItem);
        this.clientFactory.getCategoryService().loadChildCategories(path, (AsyncCallback<String[]>)new GenericCallback<String[]>(){

            public void onSuccess(String[] result) {
                for (String categoryName : result) {
                    BrowseTree.this.addCategoryItem(categoryName, treeItem);
                }
            }
        });
    }
}

