/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.browse;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.rpc.PushClient;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.client.rpc.ServerPushNotification;
import org.drools.guvnor.client.util.Activity;
import org.drools.guvnor.client.util.Util;
import org.drools.guvnor.client.widgets.tables.CategoryPagedTable;

public class CategoryActivity
extends Activity {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private final String categoryPath;
    private final ClientFactory clientFactory;

    public CategoryActivity(String categoryPath, ClientFactory clientFactory) {
        this.categoryPath = categoryPath;
        this.clientFactory = clientFactory;
    }

    @Override
    public void start(AcceptItem tabbedPanel, EventBus eventBus) {
        final CategoryPagedTable table = new CategoryPagedTable(this.categoryPath, GWT.getModuleBaseURL() + "feed/category?name=" + this.categoryPath + "&viewUrl=" + Util.getSelfURL(), this.clientFactory);
        final ServerPushNotification push = new ServerPushNotification(){

            @Override
            public void messageReceived(PushResponse response) {
                if (response.messageType.equals("categoryChange") && response.message.equals(CategoryActivity.this.categoryPath)) {
                    table.refresh();
                }
            }
        };
        PushClient.instance().subscribe(push);
        table.addUnloadListener(new Command(){

            public void execute() {
                PushClient.instance().unsubscribe(push);
            }
        });
        tabbedPanel.add(this.constants.CategoryColon() + this.subStringCategoryName(this.categoryPath), (IsWidget)table);
    }

    private String subStringCategoryName(String categoryPath) {
        return categoryPath.substring(categoryPath.lastIndexOf("/") + 1);
    }
}

