/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.browse;

import com.google.gwt.event.shared.EventBus;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.browse.InboxPlace;
import org.drools.guvnor.client.util.Activity;
import org.drools.guvnor.client.widgets.tables.InboxIncomingPagedTable;
import org.drools.guvnor.client.widgets.tables.InboxPagedTable;

public class InboxActivity
extends Activity {
    private final InboxPlace place;
    private final ClientFactory clientFactory;

    public InboxActivity(InboxPlace place, ClientFactory clientFactory) {
        this.place = place;
        this.clientFactory = clientFactory;
    }

    @Override
    public void start(AcceptItem tabbedPanel, EventBus eventBus) {
        if ("incoming".equals(this.place.getInboxType())) {
            this.openInboxIncomingPagedTable(tabbedPanel, this.clientFactory.getNavigationViewFactory().getBrowseTreeView().getInboxIncomingName(), this.place.getInboxType());
        } else if ("recentEdited".equals(this.place.getInboxType())) {
            this.openInboxPagedTable(tabbedPanel, this.clientFactory.getNavigationViewFactory().getBrowseTreeView().getInboxRecentEditedName(), this.place.getInboxType());
        } else if ("recentViewed".equals(this.place.getInboxType())) {
            this.openInboxPagedTable(tabbedPanel, this.clientFactory.getNavigationViewFactory().getBrowseTreeView().getInboxRecentViewedName(), this.place.getInboxType());
        }
    }

    private void openInboxIncomingPagedTable(AcceptItem tabbedPanel, String title, String type) {
        tabbedPanel.add(title, new InboxIncomingPagedTable(type, this.clientFactory));
    }

    private void openInboxPagedTable(AcceptItem tabbedPanel, String title, String type) {
        tabbedPanel.add(title, new InboxPagedTable(type, this.clientFactory));
    }
}

