/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.browse;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.rpc.PushClient;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.client.rpc.ServerPushNotification;
import org.drools.guvnor.client.util.Activity;
import org.drools.guvnor.client.widgets.tables.StatePagedTable;

public class StateActivity
extends Activity {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private final String stateName;
    private final ClientFactory clientFactory;

    public StateActivity(String stateName, ClientFactory clientFactory) {
        this.stateName = stateName;
        this.clientFactory = clientFactory;
    }

    @Override
    public void start(AcceptItem tabbedPanel, EventBus eventBus) {
        final StatePagedTable table = new StatePagedTable(this.stateName, this.clientFactory);
        final ServerPushNotification push = new ServerPushNotification(){

            @Override
            public void messageReceived(PushResponse response) {
                if (response.messageType.equals("statusChange") && response.message.equals(StateActivity.this.stateName)) {
                    table.refresh();
                }
            }
        };
        PushClient.instance().subscribe(push);
        table.addUnloadListener(new Command(){

            public void execute() {
                PushClient.instance().unsubscribe(push);
            }
        });
        tabbedPanel.add(this.constants.Status() + this.stateName, (IsWidget)table);
    }
}

