/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.util;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.layout.client.Layout;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.resources.ImagesCore;

public class ScrollTabLayoutPanel
extends Composite {
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private final double barHeight = 2.0;
    private final Style.Unit barUnit = Style.Unit.EM;
    private final CustomTabLayoutPanel layout = new CustomTabLayoutPanel(2.0, this.barUnit);
    private Image scrollLeft;
    private Image scrollRight;
    private FlowPanel tabBar = null;
    private LayoutPanel panel;
    private static final int ScrollLengh = 100;
    private boolean isScrollingEnabled = false;
    private HandlerRegistration windowResizeHandler;
    private boolean canSelectTabToggle = false;

    public ScrollTabLayoutPanel() {
        this.initWidget((Widget)this.layout);
        this.panel = this.layout.getLayoutPanel();
        for (int i = 0; i < this.panel.getWidgetCount(); ++i) {
            Widget widget = this.panel.getWidget(i);
            if (!(widget instanceof FlowPanel)) continue;
            this.tabBar = (FlowPanel)widget;
            break;
        }
    }

    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<Integer> handler) {
        return this.layout.addBeforeSelectionHandler(handler);
    }

    public boolean isCanSelectTabToggle() {
        return this.canSelectTabToggle;
    }

    public void selectTab(Widget child) {
        this.canSelectTabToggle = true;
        this.layout.selectTab(child);
        this.canSelectTabToggle = false;
    }

    public void add(Widget child, Widget tab) {
        this.canSelectTabToggle = true;
        this.layout.add(child, tab);
        this.checkIfScrollButtonsNecessary();
        this.canSelectTabToggle = false;
    }

    public boolean remove(Widget w) {
        boolean b = this.layout.remove(w);
        this.checkIfScrollButtonsNecessary();
        return b;
    }

    protected void onLoad() {
        super.onLoad();
        if (this.windowResizeHandler == null) {
            this.windowResizeHandler = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

                public void onResize(ResizeEvent event) {
                    ScrollTabLayoutPanel.this.checkIfScrollButtonsNecessary();
                }
            });
        }
    }

    protected void onUnload() {
        super.onUnload();
        if (this.windowResizeHandler != null) {
            this.windowResizeHandler.removeHandler();
            this.windowResizeHandler = null;
        }
    }

    private void enableScroll() {
        if (!this.isScrollingEnabled) {
            this.scrollRight = new Image(images.scrollRight());
            this.scrollLeft = new Image(images.scrollLeft());
            this.scrollLeft.addClickHandler(this.createScrollClickHandler(100));
            this.scrollRight.addClickHandler(this.createScrollClickHandler(-100));
            this.panel.setWidgetLeftRight((Widget)this.tabBar, 30.0, Style.Unit.PX, 30.0, Style.Unit.PX);
            this.panel.setWidgetTopHeight((Widget)this.tabBar, 0.0, Style.Unit.PX, 2.0, this.barUnit);
            this.panel.setWidgetVerticalPosition((Widget)this.tabBar, Layout.Alignment.END);
            this.panel.add((Widget)this.scrollRight);
            this.panel.setWidgetRightWidth((Widget)this.scrollRight, 0.0, Style.Unit.PX, 27.0, Style.Unit.PX);
            this.panel.setWidgetTopHeight((Widget)this.scrollRight, 0.0, Style.Unit.PX, 2.0, this.barUnit);
            this.panel.setWidgetVerticalPosition((Widget)this.scrollRight, Layout.Alignment.END);
            this.panel.add((Widget)this.scrollLeft);
            this.panel.setWidgetLeftWidth((Widget)this.scrollLeft, 0.0, Style.Unit.PX, 27.0, Style.Unit.PX);
            this.panel.setWidgetTopHeight((Widget)this.scrollLeft, 0.0, Style.Unit.PX, 2.0, this.barUnit);
            this.panel.setWidgetVerticalPosition((Widget)this.scrollLeft, Layout.Alignment.END);
            this.isScrollingEnabled = true;
        }
    }

    private void disableScroll() {
        if (this.isScrollingEnabled) {
            this.panel.remove((Widget)this.scrollRight);
            this.panel.remove((Widget)this.scrollLeft);
            this.panel.setWidgetLeftRight((Widget)this.tabBar, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
            this.panel.setWidgetTopHeight((Widget)this.tabBar, 0.0, Style.Unit.PX, 2.0, this.barUnit);
            this.panel.setWidgetVerticalPosition((Widget)this.tabBar, Layout.Alignment.END);
            this.isScrollingEnabled = false;
        }
    }

    private void checkIfScrollButtonsNecessary() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                boolean isScrolling = ScrollTabLayoutPanel.this.isScrollingNecessary();
                if (isScrolling) {
                    ScrollTabLayoutPanel.this.enableScroll();
                } else {
                    ScrollTabLayoutPanel.this.disableScroll();
                }
            }
        });
    }

    private boolean isScrollingNecessary() {
        Widget lastTab = this.getLastTab();
        if (lastTab == null) {
            return false;
        }
        return this.getRightOfWidget(lastTab) > this.getTabBarWidth();
    }

    private ClickHandler createScrollClickHandler(final int diff) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                Widget lastTab = ScrollTabLayoutPanel.this.getLastTab();
                if (lastTab == null) {
                    return;
                }
                int newLeft = ScrollTabLayoutPanel.parsePosition(ScrollTabLayoutPanel.this.tabBar.getElement().getStyle().getLeft()) + diff;
                int rightOfLastTab = ScrollTabLayoutPanel.this.getRightOfWidget(lastTab);
                if (newLeft <= 0 && ScrollTabLayoutPanel.this.getTabBarWidth() - newLeft < rightOfLastTab + 100) {
                    ScrollTabLayoutPanel.this.scrollTo(newLeft);
                }
            }
        };
    }

    private void scrollTo(int pos) {
        this.tabBar.getElement().getStyle().setLeft((double)pos, Style.Unit.PX);
    }

    private int getRightOfWidget(Widget widget) {
        return widget.getElement().getOffsetLeft() + widget.getElement().getOffsetWidth();
    }

    private int getTabBarWidth() {
        return this.tabBar.getElement().getParentElement().getClientWidth();
    }

    private Widget getLastTab() {
        if (this.tabBar.getWidgetCount() == 0) {
            return null;
        }
        return this.tabBar.getWidget(this.tabBar.getWidgetCount() - 1);
    }

    private static int parsePosition(String positionString) {
        int position;
        try {
            for (int i = 0; i < positionString.length(); ++i) {
                char c = positionString.charAt(i);
                if (c == '-' || c >= '0' && c <= '9') continue;
                positionString = positionString.substring(0, i);
            }
            position = Integer.parseInt(positionString);
        }
        catch (NumberFormatException ex) {
            position = 0;
        }
        return position;
    }

    public int getSelectedIndex() {
        return this.layout.getSelectedIndex();
    }

    public int getWidgetCount() {
        return this.layout.getWidgetCount();
    }

    class CustomTabLayoutPanel
    extends TabLayoutPanel {
        public CustomTabLayoutPanel(double barHeight, Style.Unit barUnit) {
            super(barHeight, barUnit);
        }

        LayoutPanel getLayoutPanel() {
            return (LayoutPanel)this.getWidget();
        }
    }
}

