/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.resources.TableImageResources;

public class ColumnPicker<T> {
    private final Image COLUMN_PICKER_IMAGE = new Image(TableImageResources.INSTANCE.columnPicker());
    private final CellTable<T> cellTable;
    private List<ColumnMeta<T>> columnMetaList = new ArrayList<ColumnMeta<T>>();

    public ColumnPicker(CellTable<T> cellTable) {
        this.cellTable = cellTable;
    }

    public void addColumn(Column<T, ?> column, Header<String> header, boolean visible) {
        this.addColumn(new ColumnMeta(column, header, visible));
    }

    private void addColumn(ColumnMeta<T> columnMeta) {
        this.columnMetaList.add(columnMeta);
        if (columnMeta.isVisible()) {
            this.cellTable.addColumn(columnMeta.getColumn(), columnMeta.getHeader());
        }
    }

    public ToggleButton createToggleButton() {
        final ToggleButton button = new ToggleButton(this.COLUMN_PICKER_IMAGE);
        final PopupPanel popup = new PopupPanel(true);
        popup.addAutoHidePartner((Element)button.getElement());
        popup.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> popupPanelCloseEvent) {
                button.setDown(false);
            }
        });
        VerticalPanel popupContent = new VerticalPanel();
        for (final ColumnMeta<T> columnMeta : this.columnMetaList) {
            CheckBox checkBox = new CheckBox((String)columnMeta.getHeader().getValue());
            checkBox.setValue(Boolean.valueOf(columnMeta.isVisible()));
            checkBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> booleanValueChangeEvent) {
                    boolean visible = (Boolean)booleanValueChangeEvent.getValue();
                    if (visible) {
                        for (ColumnMeta resettingColumnMeta : ColumnPicker.this.columnMetaList) {
                            if (!resettingColumnMeta.isVisible()) continue;
                            ColumnPicker.this.cellTable.removeColumn(resettingColumnMeta.getColumn());
                        }
                        columnMeta.setVisible(visible);
                        for (ColumnMeta resettingColumnMeta : ColumnPicker.this.columnMetaList) {
                            if (!resettingColumnMeta.isVisible()) continue;
                            ColumnPicker.this.cellTable.addColumn(resettingColumnMeta.getColumn(), resettingColumnMeta.getHeader());
                        }
                    } else {
                        columnMeta.setVisible(visible);
                        ColumnPicker.this.cellTable.removeColumn(columnMeta.getColumn());
                    }
                }
            });
            popupContent.add((Widget)checkBox);
        }
        popup.add((Widget)popupContent);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (button.isDown()) {
                    popup.setPopupPosition(button.getAbsoluteLeft(), button.getAbsoluteTop() + button.getOffsetHeight());
                    popup.show();
                } else {
                    popup.hide(false);
                }
            }
        });
        return button;
    }

    private static class ColumnMeta<T> {
        private Column<T, ?> column;
        private Header<String> header;
        private boolean visible;

        private ColumnMeta(Column<T, ?> column, Header<String> header, boolean visible) {
            this.column = column;
            this.header = header;
            this.visible = visible;
        }

        public Column<T, ?> getColumn() {
            return this.column;
        }

        public Header<String> getHeader() {
            return this.header;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }
}

