/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.util.Date;
import org.drools.guvnor.client.common.AssetEditorFactory;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.resources.ComparableImageResource;
import org.drools.guvnor.client.rpc.InboxPageRequest;
import org.drools.guvnor.client.rpc.InboxPageRow;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.widgets.tables.AbstractAssetPagedTable;
import org.drools.guvnor.client.widgets.tables.ColumnPicker;
import org.drools.guvnor.client.widgets.tables.ComparableImageResourceCell;
import org.drools.guvnor.client.widgets.tables.IsInboxPagedTable;
import org.drools.guvnor.client.widgets.tables.SortableHeader;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;

public class InboxPagedTable
extends AbstractAssetPagedTable<InboxPageRow>
implements IsInboxPagedTable {
    private static final int PAGE_SIZE = 10;
    private final ClientFactory clientFactory;

    public InboxPagedTable(final String inboxName, ClientFactory clientFactory) {
        super(10, clientFactory);
        this.clientFactory = clientFactory;
        this.setDataProvider(new AsyncDataProvider<InboxPageRow>(){

            protected void onRangeChanged(HasData<InboxPageRow> display) {
                InboxPageRequest request = new InboxPageRequest();
                request.setInboxName(inboxName);
                request.setStartRowIndex(InboxPagedTable.this.pager.getPageStart());
                request.setPageSize(InboxPagedTable.this.pageSize);
                InboxPagedTable.this.repositoryService.loadInbox(request, (AsyncCallback<PageResponse<InboxPageRow>>)new GenericCallback<PageResponse<InboxPageRow>>(){

                    public void onSuccess(PageResponse<InboxPageRow> response) {
                        this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                        this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                    }
                });
            }
        });
    }

    @Override
    protected void addAncillaryColumns(ColumnPicker<InboxPageRow> columnPicker, SortableHeaderGroup<InboxPageRow> sortableHeaderGroup) {
        Column<InboxPageRow, ComparableImageResource> formatColumn = new Column<InboxPageRow, ComparableImageResource>((Cell)new ComparableImageResourceCell()){

            public ComparableImageResource getValue(InboxPageRow row) {
                AssetEditorFactory factory = InboxPagedTable.this.clientFactory.getAssetEditorFactory();
                return new ComparableImageResource(row.getFormat(), factory.getAssetEditorIcon(row.getFormat()));
            }
        };
        columnPicker.addColumn(formatColumn, new SortableHeader<InboxPageRow, ComparableImageResource>(sortableHeaderGroup, constants.Format(), formatColumn), true);
        TextColumn<InboxPageRow> noteColumn = new TextColumn<InboxPageRow>(){

            public String getValue(InboxPageRow row) {
                return row.getNote();
            }
        };
        columnPicker.addColumn((Column<InboxPageRow, ?>)noteColumn, new SortableHeader(sortableHeaderGroup, constants.Name(), noteColumn), true);
        Column<InboxPageRow, Date> dateColumn = new Column<InboxPageRow, Date>((Cell)new DateCell(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM))){

            public Date getValue(InboxPageRow row) {
                return row.getTimestamp();
            }
        };
        columnPicker.addColumn(dateColumn, new SortableHeader<InboxPageRow, Date>(sortableHeaderGroup, constants.CreatedDate(), dateColumn), false);
    }
}

