/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.server.builder.AssemblyErrorLogger;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentAssemblyError;
import org.drools.guvnor.server.builder.ModuleAssembler;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.VersionedAssetItemIterator;

abstract class AssemblerBase
implements ModuleAssembler {
    protected ModuleItem moduleItem;
    protected BRMSPackageBuilder builder;
    protected final AssemblyErrorLogger errorLogger = new AssemblyErrorLogger();

    AssemblerBase() {
    }

    @Override
    public boolean hasErrors() {
        return this.errorLogger.hasErrors();
    }

    @Override
    public List<ContentAssemblyError> getErrors() {
        return this.errorLogger.getErrors();
    }

    protected Iterator<AssetItem> getAllAssets() {
        Iterator iterator = this.moduleItem.getAssets();
        ((VersionedAssetItemIterator)iterator).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
        return iterator;
    }

    protected Iterator<AssetItem> getAssetItemIterator(String ... formats) {
        return this.moduleItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(formats);
    }

    protected List<AssetItem> getAllNotToIncludeAssets(StringBuilder includedAssets) {
        return null;
    }
}

