/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.server.CategoryFilter;
import org.drools.guvnor.server.ModuleFilter;
import org.drools.guvnor.server.builder.pagerow.PageRowBuilder;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.util.QueryPageRowCreator;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.RepositoryFilter;
import org.jboss.seam.security.Identity;

public class QueryFullTextPageRowBuilder
implements PageRowBuilder<QueryPageRequest, Iterator<AssetItem>> {
    private QueryPageRequest pageRequest;
    private Iterator<AssetItem> iterator;
    private Identity identity;

    @Override
    public List<QueryPageRow> build() {
        this.validate();
        int skipped = 0;
        Integer pageSize = this.pageRequest.getPageSize();
        int startRowIndex = this.pageRequest.getStartRowIndex();
        ModuleFilter filter = new ModuleFilter(this.identity);
        CategoryFilter categoryFilter = new CategoryFilter(this.identity);
        ArrayList<QueryPageRow> rowList = new ArrayList<QueryPageRow>();
        while (this.iterator.hasNext() && (pageSize == null || rowList.size() < pageSize)) {
            AssetItem assetItem = this.iterator.next();
            if (!this.checkPackagePermissionHelper(filter, assetItem, RoleType.PACKAGE_READONLY.getName()) && !this.checkCategoryPermissionHelper(categoryFilter, assetItem, RoleType.ANALYST_READ.getName())) continue;
            if (skipped >= startRowIndex) {
                rowList.add(QueryPageRowCreator.makeQueryPageRow(assetItem));
            }
            ++skipped;
        }
        return rowList;
    }

    private boolean checkPackagePermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        return filter.accept((Object)this.getConfigDataHelper(item.getModule().getUUID()), roleType);
    }

    private boolean checkCategoryPermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        List tempCateList = item.getCategories();
        for (CategoryItem categoryItem : tempCateList) {
            if (!filter.accept((Object)categoryItem.getFullPath(), roleType)) continue;
            return true;
        }
        return false;
    }

    private Module getConfigDataHelper(String uuidStr) {
        Module data = new Module();
        data.setUuid(uuidStr);
        return data;
    }

    @Override
    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.iterator == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }

    public QueryFullTextPageRowBuilder withPageRequest(QueryPageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public QueryFullTextPageRowBuilder withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public QueryFullTextPageRowBuilder withContent(Iterator<AssetItem> iterator) {
        this.iterator = iterator;
        return this;
    }
}

