/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;

public abstract class ContentHandler {
    public abstract void retrieveAssetContent(Asset var1, AssetItem var2) throws SerializationException;

    public abstract void storeAssetContent(Asset var1, AssetItem var2) throws SerializationException;

    public boolean isRuleAsset() {
        return this instanceof IRuleAsset;
    }

    private String findParentCategory(AssetItem asset, String currentCat) {
        CategoryItem item = asset.getRulesRepository().loadCategory("/");
        return this.findCategoryInChild(item, currentCat);
    }

    private String findCategoryInChild(CategoryItem item, String currentCat) {
        List children = item.getChildTags();
        for (Object aChildren : children) {
            if (((CategoryItem)aChildren).getName().equals(currentCat)) {
                return item.getName();
            }
            String check = this.findCategoryInChild((CategoryItem)aChildren, currentCat);
            if (check == null || check.length() <= 0) continue;
            return check;
        }
        return "";
    }

    private String findKeyforValue(HashMap<String, String> catRules, String catToFind) {
        for (Map.Entry<String, String> stringStringEntry : catRules.entrySet()) {
            if (!stringStringEntry.getValue().equals(catToFind)) continue;
            return stringStringEntry.getKey();
        }
        return "";
    }

    protected String parentNameFromCategory(AssetItem asset, String currentParent) {
        List cats = asset.getCategories();
        String catName = null;
        if (cats.size() > 0) {
            catName = ((CategoryItem)cats.get(0)).getName();
        }
        HashMap categoryRules = asset.getModule().getCategoryRules();
        String newParent = currentParent;
        if (null != categoryRules && null != catName) {
            String ruleName = asset.getName();
            if (categoryRules.containsKey(ruleName)) {
                String parentCategory = this.findParentCategory(asset, (String)categoryRules.get(ruleName));
                newParent = parentCategory != null && parentCategory.length() > 0 && categoryRules.containsValue(parentCategory) ? this.findKeyforValue(categoryRules, parentCategory) : "";
            } else if (currentParent != null && currentParent.length() > 0) {
                newParent = currentParent;
            } else if (categoryRules.containsValue(catName)) {
                newParent = this.findKeyforValue(categoryRules, catName);
            }
        }
        return newParent;
    }
}

