/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;

public class AssetZipper {
    private final List<AssetItem> assets;

    public AssetZipper(List<AssetItem> assets) {
        this.assets = assets;
    }

    public AssetZipper(List<AssetItem> assets, ModuleItem pkg) {
        this.assets = assets;
    }

    public InputStream zipAssets() {
        AssetItem zipFileElement = null;
        BufferedInputStream inputZip = null;
        Iterator<AssetItem> it = this.assets.iterator();
        byte[] data = new byte[1000];
        int count = 0;
        try {
            if (this.assets.size() > 1) {
                ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
                ZipOutputStream outputZip = new ZipOutputStream(outputBytes);
                while (it.hasNext()) {
                    zipFileElement = it.next();
                    inputZip = new BufferedInputStream(zipFileElement.getBinaryContentAttachment());
                    String fileName = null;
                    String binaryContentAttachmentFileName = zipFileElement.getBinaryContentAttachmentFileName();
                    fileName = binaryContentAttachmentFileName != null && !"".equals(binaryContentAttachmentFileName) ? binaryContentAttachmentFileName : zipFileElement.getName() + "." + zipFileElement.getFormat();
                    outputZip.putNextEntry(new ZipEntry(fileName));
                    while ((count = inputZip.read(data, 0, 1000)) != -1) {
                        outputZip.write(data, 0, count);
                    }
                    outputZip.flush();
                    inputZip.close();
                }
                outputZip.close();
                return new ByteArrayInputStream(outputBytes.toByteArray());
            }
            return it.next().getBinaryContentAttachment();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

