/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.jaxrs;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.drools.guvnor.server.jaxrs.Resource;
import org.drools.guvnor.server.jaxrs.Translator;
import org.drools.guvnor.server.jaxrs.jaxb.Asset;
import org.drools.guvnor.server.jaxrs.jaxb.Category;
import org.drools.guvnor.server.jaxrs.providers.atom.Entry;
import org.drools.guvnor.server.jaxrs.providers.atom.Feed;
import org.drools.guvnor.server.jaxrs.providers.atom.Link;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemPageResult;
import org.drools.repository.CategoryItem;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.seam.security.annotations.LoggedIn;

@Path(value="/categories")
@RequestScoped
@Named
@LoggedIn
@GZIP
public class CategoryResource
extends Resource {
    private final int pageSize = 10;

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Collection<Category> getCategoriesAsJAXB() {
        ArrayList<Category> ret = new ArrayList<Category>();
        CategoryItem rootItem = this.rulesRepository.loadCategory("/");
        this.addChildrenRecursively(ret, rootItem);
        return ret;
    }

    private void addChildrenRecursively(Collection<Category> ret, CategoryItem categoryItem) {
        List children = categoryItem.getChildTags();
        for (CategoryItem child : children) {
            ret.add(Translator.toCategory(child, this.uriInfo));
            this.addChildrenRecursively(ret, child);
        }
    }

    @GET
    @Path(value="{categoryPath:.+}")
    @Produces(value={"application/json", "application/xml"})
    public Category getCategoryAsJAXB(@PathParam(value="categoryPath") String categoryPath) {
        CategoryItem categoryItem = this.rulesRepository.loadCategory(categoryPath);
        return Translator.toCategory(categoryItem, this.uriInfo);
    }

    @GET
    @Path(value="{categoryPath:.+}/children")
    @Produces(value={"application/json", "application/xml"})
    public Collection<Category> getCategoryChildrenAsJAXB(@PathParam(value="categoryPath") String categoryPath) {
        CategoryItem categoryItem = this.rulesRepository.loadCategory(categoryPath);
        ArrayList<Category> ret = new ArrayList<Category>();
        List children = categoryItem.getChildTags();
        for (CategoryItem child : children) {
            ret.add(Translator.toCategory(child, this.uriInfo));
        }
        return ret;
    }

    @GET
    @Path(value="{categoryPath:.+}/assets")
    @Produces(value={"application/atom+xml"})
    public Feed getAssetsAsAtom(@PathParam(value="categoryPath") String categoryPath) {
        Feed f = new Feed();
        f.setTitle(categoryPath);
        AssetItemPageResult result = this.rulesRepository.findAssetsByCategory(categoryPath, 0, 10);
        List assets = result.assets;
        for (AssetItem item : assets) {
            Entry e = Translator.toAssetEntryAbdera(item, this.uriInfo);
            f.getEntries().add(e);
        }
        if (result.hasNext) {
            Link l = new Link();
            l.setRel("next-page");
            l.setHref(this.uriInfo.getBaseUriBuilder().path("categories/{categoryPath}/assets//page/{pageNumber}").build(new Object[]{categoryPath, 1}));
            f.getLinks().add(l);
        }
        return f;
    }

    @GET
    @Path(value="{categoryPath:.+}/assets")
    @Produces(value={"application/json", "application/xml"})
    public Collection<Asset> getAssetsAsJAXB(@PathParam(value="categoryPath") String categoryPath) {
        ArrayList<Asset> ret = new ArrayList<Asset>();
        AssetItemPageResult result = this.rulesRepository.findAssetsByCategory(categoryPath, 0, 10);
        List assets = result.assets;
        for (AssetItem item : assets) {
            ret.add(Translator.toAsset(item, this.uriInfo));
        }
        return ret;
    }

    @PUT
    @Path(value="{categoryPath:.+}")
    @Consumes(value={"*/*"})
    public void createCategory(@PathParam(value="categoryPath") String categoryPath) {
        String name;
        String parentPath;
        int lastDotIndex = categoryPath.lastIndexOf("/");
        if (lastDotIndex >= 0) {
            parentPath = categoryPath.substring(0, lastDotIndex);
            name = categoryPath.substring(lastDotIndex + 1);
        } else {
            parentPath = "";
            name = categoryPath;
        }
        this.repositoryCategoryService.createCategory(parentPath, name, "TODO");
    }

    @DELETE
    @Path(value="{categoryPath:.+}")
    @Consumes(value={"*/*"})
    public void deleteCategory(@PathParam(value="categoryPath") String categoryPath) {
        try {
            this.repositoryCategoryService.removeCategory(categoryPath);
        }
        catch (SerializationException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{categoryName:.+}/assets//page/{page}")
    @Produces(value={"application/json", "application/xml"})
    public Collection<Asset> getAssetsAsJAXBIndex(@PathParam(value="categoryName") String categoryName, @PathParam(value="page") int page) {
        ArrayList<Asset> ret = new ArrayList<Asset>();
        AssetItemPageResult result = this.rulesRepository.findAssetsByCategory(categoryName, page, 10);
        List assets = result.assets;
        for (AssetItem item : assets) {
            ret.add(Translator.toAsset(item, this.uriInfo));
        }
        return ret;
    }
}

