/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.repository;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.guvnor.server.repository.GuvnorBootstrapConfiguration;
import org.drools.guvnor.server.repository.RepositoryStartupService;
import org.drools.guvnor.server.repository.UserInbox;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.UserInfo;
import org.drools.repository.events.CheckinEvent;
import org.drools.repository.events.StorageEventManager;

@ApplicationScoped
public class MailboxService {
    private static final LoggingHelper log = LoggingHelper.getLogger(MailboxService.class);
    private ExecutorService executor = null;
    private volatile String mailmanUsername = null;
    @Inject
    private RepositoryStartupService repositoryStartupService;
    @Inject
    protected GuvnorBootstrapConfiguration guvnorBootstrapConfiguration;
    private volatile RulesRepository mailmanRulesRepository;

    @PostConstruct
    public void setup() {
        this.mailmanUsername = this.guvnorBootstrapConfiguration.extractMailmanUsername();
        if (this.mailmanUsername == null || this.mailmanUsername.length() == 0) {
            throw new IllegalStateException("The mailmanUsername (" + this.mailmanUsername + ") cannot be empty.");
        }
        String mailmanPassword = this.guvnorBootstrapConfiguration.extractMailmanPassword();
        this.mailmanRulesRepository = new RulesRepository(this.repositoryStartupService.newSession(this.mailmanUsername, mailmanPassword));
        this.executor = Executors.newSingleThreadExecutor();
        log.info("mailbox service is up");
        this.registerCheckinListener();
        this.wakeUp();
    }

    public void registerCheckinListener() {
        StorageEventManager.registerCheckinEvent((CheckinEvent)new CheckinEvent(){

            public void afterCheckin(AssetItem item) {
                UserInbox.recordUserEditEvent(item);
                MailboxService.this.recordItemUpdated(item);
                MailboxService.this.wakeUp();
            }
        });
        log.info("CheckinListener registered");
    }

    @PreDestroy
    public void destroy() {
        this.stopExecutor();
        this.mailmanRulesRepository.logout();
        log.info("Removing listeners....");
        StorageEventManager.removeListeners();
    }

    public void stopExecutor() {
        log.info("Shutting down mailbox service");
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    System.err.println("executor did not terminate");
                }
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        log.info("Mailbox service is shutdown.");
    }

    public void wakeUp() {
        log.debug("Waking up");
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                MailboxService.this.processOutgoing();
            }
        });
    }

    void processOutgoing() {
        UserInbox mailman = new UserInbox(this.mailmanRulesRepository, this.mailmanUsername);
        final List<UserInfo.InboxEntry> es = mailman.loadIncoming();
        log.debug("Outgoing messages size " + es.size());
        UserInfo.eachUser((RulesRepository)this.mailmanRulesRepository, (UserInfo.Command)new UserInfo.Command(){

            public void process(String toUser) {
                log.debug("Processing any inbound messages for " + toUser);
                if (toUser.equals(MailboxService.this.mailmanUsername)) {
                    return;
                }
                UserInbox inbox = new UserInbox(MailboxService.this.mailmanRulesRepository, toUser);
                Set recentEdited = MailboxService.this.makeSetOf(inbox.loadRecentEdited());
                for (UserInfo.InboxEntry e : es) {
                    if (e.from.equals(toUser) || !recentEdited.contains(e.assetUUID)) continue;
                    inbox.addToIncoming(e.assetUUID, e.note, e.from);
                }
            }
        });
        mailman.clearIncoming();
        this.mailmanRulesRepository.save();
    }

    private Set<String> makeSetOf(List<UserInfo.InboxEntry> inboxEntries) {
        HashSet<String> entries = new HashSet<String>();
        for (UserInfo.InboxEntry e : inboxEntries) {
            entries.add(e.assetUUID);
        }
        return entries;
    }

    public void recordItemUpdated(AssetItem item) {
        final String id = item.getUUID();
        final String name = item.getName();
        final String from = item.getRulesRepository().getSession().getUserID();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                UserInbox inbox = new UserInbox(MailboxService.this.mailmanRulesRepository, MailboxService.this.mailmanUsername);
                inbox.addToIncoming(id, name, from);
                MailboxService.this.processOutgoing();
                MailboxService.this.mailmanRulesRepository.save();
            }
        });
    }
}

