/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import com.google.gwt.user.client.rpc.SerializationException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.TableConfig;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.guvnor.server.util.RowLoader;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.AssetItemPageResult;

public class TableDisplayHandler {
    private static final int ROWS_PER_PAGE = 40;
    private final RowLoader ASSET_LIST;

    public TableDisplayHandler(String tableconfig) {
        this.ASSET_LIST = new RowLoader(tableconfig);
    }

    public TableDataResult loadRuleListTable(AssetItemPageResult list) throws SerializationException {
        List<TableDataRow> data = this.loadRows(list.assets.iterator(), -1);
        TableDataResult result = new TableDataResult();
        result.data = data.toArray(new TableDataRow[data.size()]);
        result.currentPosition = list.currentPosition;
        result.hasNext = list.hasNext;
        return result;
    }

    private TableDataResult loadRuleListTable(List<AssetItem> assetList, long curPos, boolean hasNext) throws SerializationException {
        List<TableDataRow> data = this.loadRows(assetList.iterator(), -1);
        TableDataResult result = new TableDataResult();
        result.data = data.toArray(new TableDataRow[data.size()]);
        result.currentPosition = curPos;
        result.hasNext = hasNext;
        return result;
    }

    public TableDataResult loadRuleListTable(List<AssetItem> assetList, int skip, int numRows) throws SerializationException {
        int size = assetList.size();
        boolean hasNext = false;
        int startPos = 0;
        int endPos = 0;
        if (numRows != -1) {
            if (skip > size) {
                ArrayList<AssetItem> tempList = new ArrayList<AssetItem>();
                return this.loadRuleListTable(tempList, 0L, false);
            }
            if (skip > 0) {
                startPos = skip;
            } else {
                skip = 0;
            }
            if (skip + numRows > size) {
                endPos = size;
            } else {
                endPos = skip + numRows;
                hasNext = true;
            }
            List<AssetItem> tempList2 = assetList.subList(startPos, endPos);
            return this.loadRuleListTable(tempList2, (long)endPos, hasNext);
        }
        return this.loadRuleListTable(assetList, 0L, false);
    }

    public TableDataResult loadRuleListTable(AssetItemIterator it, int skip, int numRows) {
        if (numRows != -1) {
            it.skip((long)skip);
        }
        List<TableDataRow> data = this.loadRows((Iterator<AssetItem>)it, numRows);
        TableDataResult result = new TableDataResult();
        result.data = data.toArray(new TableDataRow[data.size()]);
        result.total = it.getSize();
        result.hasNext = it.hasNext();
        result.currentPosition = it.getPosition();
        return result;
    }

    private List<TableDataRow> loadRows(Iterator<AssetItem> iterator, int numRows) {
        ArrayList<TableDataRow> data = new ArrayList<TableDataRow>();
        while (iterator.hasNext()) {
            AssetItem r = iterator.next();
            TableDataRow row = new TableDataRow();
            row.id = r.getUUID();
            row.format = r.getFormat();
            row.values = this.ASSET_LIST.getRow(r);
            data.add(row);
            if (numRows == -1 || data.size() != numRows) continue;
            break;
        }
        return data;
    }

    public String formatDate(Calendar cal) {
        DateFormat localFormat = DateFormat.getDateInstance();
        return localFormat.format(cal.getTime());
    }

    public TableConfig loadTableConfig() {
        TableConfig config = new TableConfig();
        config.headers = this.ASSET_LIST.getHeaders();
        config.headerTypes = this.ASSET_LIST.getHeaderTypes();
        config.rowsPerPage = 40;
        return config;
    }
}

