/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.services.datamodeller.core.JavaType;
import org.kie.workbench.common.services.datamodeller.core.JavaTypeKind;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations;

public abstract class AbstractJavaType
extends AbstractHasAnnotations
implements JavaType {
    protected String name;
    protected String packageName;
    protected JavaType enclosingType;
    protected List<JavaType> nestedTypes = new ArrayList<JavaType>();
    protected Visibility visibility = Visibility.PACKAGE_PRIVATE;
    protected JavaTypeKind typeKind = JavaTypeKind.CLASS;

    protected AbstractJavaType() {
    }

    protected AbstractJavaType(String packageName, String name, JavaTypeKind typeKind) {
        this.packageName = packageName;
        this.name = name;
        this.typeKind = typeKind;
    }

    protected AbstractJavaType(String packageName, String name, JavaTypeKind typeKind, Visibility visibility) {
        this(packageName, name, typeKind);
        this.visibility = visibility;
    }

    @Override
    public JavaTypeKind getTypeKind() {
        return this.typeKind;
    }

    @Override
    public boolean isClass() {
        return this.typeKind == JavaTypeKind.CLASS;
    }

    @Override
    public boolean isEnum() {
        return this.typeKind == JavaTypeKind.ENUM;
    }

    @Override
    public boolean isInterface() {
        return this.typeKind == JavaTypeKind.INTERFACE;
    }

    @Override
    public boolean isAnnotation() {
        return this.typeKind == JavaTypeKind.ANNOTATION;
    }

    @Override
    public JavaType getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public String getClassName() {
        return (this.packageName != null && !"".equals(this.packageName) ? this.packageName + "." : "") + this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<JavaType> getNestedTypes() {
        return this.nestedTypes;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public boolean isPackagePrivate() {
        return this.visibility == Visibility.PACKAGE_PRIVATE;
    }

    @Override
    public boolean isPublic() {
        return this.visibility == Visibility.PUBLIC;
    }

    @Override
    public boolean isPrivate() {
        return this.visibility == Visibility.PRIVATE;
    }

    @Override
    public boolean isProtected() {
        return this.visibility == Visibility.PROTECTED;
    }

    @Override
    public Visibility getVisibilty() {
        return this.visibility;
    }

    @Override
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractJavaType that = (AbstractJavaType)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.packageName != null ? !this.packageName.equals(that.packageName) : that.packageName != null) {
            return false;
        }
        if (this.enclosingType != null ? !this.enclosingType.equals(that.enclosingType) : that.enclosingType != null) {
            return false;
        }
        if (this.nestedTypes != null ? !this.nestedTypes.equals(that.nestedTypes) : that.nestedTypes != null) {
            return false;
        }
        if (this.visibility != that.visibility) {
            return false;
        }
        return this.typeKind == that.typeKind;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = ~(~result);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.enclosingType != null ? this.enclosingType.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.nestedTypes != null ? this.nestedTypes.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.typeKind != null ? this.typeKind.hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

