/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.extract;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;

public class ExtractArchive {
    private Log logger;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void extractArchive(File archive, File destination) {
        Archive arch = null;
        try {
            arch = new Archive(archive);
        }
        catch (RarException e) {
            this.logError(e);
        }
        catch (IOException e1) {
            this.logError(e1);
        }
        if (arch != null) {
            if (arch.isEncrypted()) {
                this.logWarn("archive is encrypted cannot extreact");
                return;
            }
            FileHeader fh = null;
            while ((fh = arch.nextFileHeader()) != null) {
                String fileNameString = fh.getFileNameString();
                if (fh.isEncrypted()) {
                    this.logWarn("file is encrypted cannot extract: " + fileNameString);
                    continue;
                }
                this.logInfo("extracting: " + fileNameString);
                try {
                    if (fh.isDirectory()) {
                        ExtractArchive.createDirectory(fh, destination);
                        continue;
                    }
                    File f = this.createFile(fh, destination);
                    FileOutputStream stream = new FileOutputStream(f);
                    arch.extractFile(fh, stream);
                    ((OutputStream)stream).close();
                }
                catch (IOException e) {
                    this.logError(e, "error extracting the file");
                }
                catch (RarException e) {
                    this.logError(e, "error extraction the file");
                }
            }
        }
    }

    private void logWarn(String warning) {
        if (this.logger != null) {
            this.logger.warn((Object)warning);
        }
    }

    private void logInfo(String info) {
        if (this.logger != null) {
            this.logger.info((Object)info);
        }
    }

    private void logError(Exception e, String errorMessage) {
        if (this.logger != null) {
            this.logger.error((Object)errorMessage, (Throwable)e);
        }
    }

    private void logError(Exception e) {
        if (this.logger != null) {
            this.logger.error((Object)e);
        }
    }

    private File createFile(FileHeader fh, File destination) {
        File f = null;
        String name = null;
        name = fh.isFileHeader() && fh.isUnicode() ? fh.getFileNameW() : fh.getFileNameString();
        f = new File(destination, name);
        if (!f.exists()) {
            try {
                f = ExtractArchive.makeFile(destination, name);
            }
            catch (IOException e) {
                this.logError(e, "error creating the new file: " + f.getName());
            }
        }
        return f;
    }

    private static File makeFile(File destination, String name) throws IOException {
        String[] dirs = name.split("\\\\");
        if (dirs == null) {
            return null;
        }
        String path = "";
        int size = dirs.length;
        if (size == 1) {
            return new File(destination, name);
        }
        if (size > 1) {
            for (int i = 0; i < dirs.length - 1; ++i) {
                path = path + File.separator + dirs[i];
                new File(destination, path).mkdir();
            }
            path = path + File.separator + dirs[dirs.length - 1];
            File f = new File(destination, path);
            f.createNewFile();
            return f;
        }
        return null;
    }

    private static void createDirectory(FileHeader fh, File destination) {
        File f = null;
        if (fh.isDirectory() && fh.isUnicode()) {
            f = new File(destination, fh.getFileNameW());
            if (!f.exists()) {
                ExtractArchive.makeDirectory(destination, fh.getFileNameW());
            }
        } else if (fh.isDirectory() && !fh.isUnicode() && !(f = new File(destination, fh.getFileNameString())).exists()) {
            ExtractArchive.makeDirectory(destination, fh.getFileNameString());
        }
    }

    private static void makeDirectory(File destination, String fileName) {
        String[] dirs = fileName.split("\\\\");
        if (dirs == null) {
            return;
        }
        String path = "";
        for (String dir : dirs) {
            path = path + File.separator + dir;
            new File(destination, path).mkdir();
        }
    }
}

