/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.rarfile;

import com.github.junrar.io.Raw;
import com.github.junrar.rarfile.SubBlockHeader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EAHeader
extends SubBlockHeader {
    private Log logger = LogFactory.getLog(this.getClass());
    public static final short EAHeaderSize = 10;
    private int unpSize;
    private byte unpVer;
    private byte method;
    private int EACRC;

    public EAHeader(SubBlockHeader sb, byte[] eahead) {
        super(sb);
        int pos = 0;
        this.unpSize = Raw.readIntLittleEndian(eahead, pos);
        this.unpVer = (byte)(this.unpVer | eahead[pos += 4] & 0xFF);
        this.method = (byte)(this.method | eahead[++pos] & 0xFF);
        this.EACRC = Raw.readIntLittleEndian(eahead, ++pos);
    }

    public int getEACRC() {
        return this.EACRC;
    }

    public byte getMethod() {
        return this.method;
    }

    public int getUnpSize() {
        return this.unpSize;
    }

    public byte getUnpVer() {
        return this.unpVer;
    }

    @Override
    public void print() {
        super.print();
        this.logger.info((Object)("unpSize: " + this.unpSize));
        this.logger.info((Object)("unpVersion: " + this.unpVer));
        this.logger.info((Object)("method: " + this.method));
        this.logger.info((Object)("EACRC:" + this.EACRC));
    }
}

