/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.adapters;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.service.SocialAdapter;
import org.ext.uberfire.social.activities.service.SocialCommandTypeFilter;
import org.ext.uberfire.social.activities.service.SocialCommandUserFilter;

@ApplicationScoped
public class CommandTimelineFilter {
    @Inject
    @Any
    private Instance<SocialCommandUserFilter> userFilters;

    public List<SocialActivitiesEvent> executeTypeCommandsOn(SocialAdapter type, Map commandsMap, List<SocialActivitiesEvent> socialActivitiesEvents) {
        for (Object mapvalue : commandsMap.keySet()) {
            socialActivitiesEvents = this.executeTypeAdapters(type, commandsMap, socialActivitiesEvents, mapvalue);
        }
        return socialActivitiesEvents;
    }

    public List<SocialActivitiesEvent> executeUserCommandsOn(List<SocialActivitiesEvent> userEvents, Map commandsMap) {
        if (this.thereIsUserFilters()) {
            for (Object mapValue : commandsMap.keySet()) {
                userEvents = this.executeUserAdapters(commandsMap, userEvents, mapValue);
            }
        }
        return userEvents;
    }

    private List<SocialActivitiesEvent> executeUserAdapters(Map commandsMap, List<SocialActivitiesEvent> userEvents, Object s) {
        Iterator iterator = this.userFilters.iterator();
        while (iterator.hasNext()) {
            String[] values;
            String key = (String)s;
            SocialCommandUserFilter socialCommandUserFilter = (SocialCommandUserFilter)iterator.next();
            if (!CommandTimelineFilter.theParameterIsThisUserAdapter(key, socialCommandUserFilter) || (values = (String[])commandsMap.get(s)).length <= 0) continue;
            String value = values[0];
            userEvents = socialCommandUserFilter.execute(value, userEvents);
        }
        return userEvents;
    }

    private boolean thereIsUserFilters() {
        return this.userFilters != null && this.userFilters.iterator().hasNext();
    }

    private List<SocialActivitiesEvent> executeTypeAdapters(SocialAdapter type, Map commandsMap, List<SocialActivitiesEvent> socialActivitiesEvents, Object s) {
        if (type.getTimelineFilters() != null) {
            Iterator iterator = type.getTimelineFilters().iterator();
            while (iterator.hasNext()) {
                String[] values;
                String key = (String)s;
                SocialCommandTypeFilter socialCommandTypeFilter = (SocialCommandTypeFilter)iterator.next();
                if (!CommandTimelineFilter.theParameterIsThisAdapter(key, socialCommandTypeFilter) || (values = (String[])commandsMap.get(s)).length <= 0) continue;
                String value = values[0];
                socialActivitiesEvents = socialCommandTypeFilter.execute(value, socialActivitiesEvents);
            }
        }
        return socialActivitiesEvents;
    }

    private static boolean theParameterIsThisAdapter(String key, SocialCommandTypeFilter socialCommandTypeFilter) {
        return key.equalsIgnoreCase(socialCommandTypeFilter.getCommandName());
    }

    private static boolean theParameterIsThisUserAdapter(String key, SocialCommandUserFilter socialCommandUserFilter) {
        return key.equalsIgnoreCase(socialCommandUserFilter.getCommandName());
    }
}

