/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.persistence;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.ext.uberfire.social.activities.server.SocialUserServicesExtendedBackEndImpl;
import org.ext.uberfire.social.activities.service.SocialUserPersistenceAPI;
import org.uberfire.backend.server.UserServicesImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public abstract class SocialUserCachePersistence
implements SocialUserPersistenceAPI {
    private static final String userNamesFileName = "userNames";
    public static final String SOCIAL_FILES = "social-files";
    SocialUserServicesExtendedBackEndImpl userServicesBackend;
    IOService ioService;
    private static final String SYSTEM_USER = "system";
    private Path userNamesPath;
    Gson gson;
    Map<String, SocialUser> usersCache = new HashMap<String, SocialUser>();
    List<String> usersNamesCache = new ArrayList<String>();

    public SocialUserCachePersistence(SocialUserServicesExtendedBackEndImpl userServicesBackend, UserServicesImpl userServices, IOService ioService, Gson gson) {
        this.userServicesBackend = userServicesBackend;
        this.ioService = ioService;
        this.gson = gson;
        this.userNamesPath = userServicesBackend.buildPath(SOCIAL_FILES, userNamesFileName);
    }

    public void setup() {
        this.syncSocialUsers();
    }

    private void syncSocialUsers() {
        try {
            this.ioService.startBatch(this.userNamesPath.getFileSystem());
            List<String> users = this.createUserNamesFile();
            this.usersNamesCache.addAll(users);
            this.createSocialUserCache(users);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public List<String> getSocialUsersName() {
        return this.usersNamesCache;
    }

    public SocialUser getSocialUser(String userName) {
        this.syncUserNamesCacheAndFile(userName);
        return this.usersCache.get(userName);
    }

    abstract String syncUserNamesCacheAndFile(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SocialUser createOrRetrieveUserData(String username) throws RuntimeException {
        SocialUser socialUser;
        Path userFile = this.userServicesBackend.buildPath(SOCIAL_FILES, username);
        if (this.ioService.exists(userFile)) {
            String json = this.ioService.readAllString(userFile);
            return (SocialUser)this.gson.fromJson(json, SocialUser.class);
        }
        try {
            this.ioService.startBatch(userFile.getFileSystem());
            SocialUser newSocialUser = new SocialUser(username);
            String json = this.gson.toJson((Object)newSocialUser);
            this.ioService.write(userFile, json, new OpenOption[0]);
            socialUser = newSocialUser;
        }
        catch (Throwable throwable) {
            try {
                this.ioService.endBatch();
                throw throwable;
            }
            catch (Exception e) {
                throw new ErrorCreatingOrRetrievingUserData(e);
            }
        }
        this.ioService.endBatch();
        return socialUser;
    }

    public abstract void updateUsers(SocialUser ... var1);

    void writeUserNamesOnFile(List<String> userNames) {
        try {
            this.ioService.startBatch(this.userNamesPath.getFileSystem());
            this.ioService.write(this.userNamesPath, this.gson.toJson(userNames), new OpenOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    private void createSocialUserCache(List<String> users) {
        for (String username : users) {
            SocialUser socialUser = this.createOrRetrieveUserData(username);
            this.usersCache.put(username, socialUser);
        }
    }

    List<String> createUserNamesFile() {
        List<String> users = this.extractUsersFromBranches();
        this.createUserNameFiles();
        this.persistUsersName(users);
        return users;
    }

    private void createUserNameFiles() {
        if (!this.ioService.exists(this.userNamesPath)) {
            this.createFile();
        }
    }

    private void persistUsersName(List<String> users) {
        this.writeUserNamesOnFile(users);
    }

    private void createFile() {
        this.ioService.createFile(this.userNamesPath, new FileAttribute[0]);
    }

    private List<String> extractUsersFromBranches() {
        ArrayList<String> userNames = new ArrayList<String>();
        for (String branchName : this.getAllBranches()) {
            String cleanName;
            if (!this.isAValidBranch(branchName) || !this.notAMergedBranch(cleanName = this.retrieveUserFrom(branchName))) continue;
            userNames.add(cleanName);
        }
        this.createSystemUser(userNames);
        return userNames;
    }

    private List<String> getAllBranches() {
        return this.userServicesBackend.getAllBranches();
    }

    private boolean notAMergedBranch(String cleanName) {
        return !cleanName.contains("upstream") && !cleanName.contains("@");
    }

    private void createSystemUser(List<String> userNames) {
        userNames.add(SYSTEM_USER);
    }

    private boolean isAValidBranch(String branchName) {
        return !branchName.contains("master");
    }

    private String retrieveUserFrom(String branchName) {
        String user = branchName;
        if (branchName.indexOf("-") > 0) {
            user = branchName.substring(0, branchName.indexOf("-"));
        }
        return user;
    }

    public SocialUser systemUser() {
        return this.getSocialUser(SYSTEM_USER);
    }

    class ErrorUpdatingUsers
    extends RuntimeException {
        public ErrorUpdatingUsers(Exception e) {
            e.printStackTrace();
        }
    }

    public class ErrorCreatingOrRetrievingUserData
    extends RuntimeException {
        public ErrorCreatingOrRetrievingUserData(Exception e) {
            e.printStackTrace();
        }
    }
}

