/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.ext.uberfire.social.activities.model.PagedSocialQuery;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.model.SocialEventType;
import org.ext.uberfire.social.activities.model.SocialPaged;
import org.ext.uberfire.social.activities.repository.SocialPageRepository;
import org.ext.uberfire.social.activities.service.SocialAdapter;
import org.ext.uberfire.social.activities.service.SocialPredicate;
import org.ext.uberfire.social.activities.service.SocialRouterAPI;
import org.ext.uberfire.social.activities.service.SocialTypeTimelinePagedRepositoryAPI;
import org.jboss.errai.bus.server.annotations.Service;

@Service
@ApplicationScoped
public class SocialTypeTimelinePagedRepository
extends SocialPageRepository
implements SocialTypeTimelinePagedRepositoryAPI {
    @Inject
    SocialRouterAPI socialRouterAPI;

    public PagedSocialQuery getEventTimeline(String adapterName, SocialPaged socialPage) {
        return this.getEventTimeline(adapterName, socialPage, new HashMap(), null);
    }

    public PagedSocialQuery getEventTimeline(SocialAdapter adapter, SocialPaged socialPaged) {
        return this.getEventTimeline(adapter, socialPaged, new HashMap(), null);
    }

    public PagedSocialQuery getEventTimeline(String adapterName, SocialPaged socialPage, SocialPredicate<SocialActivitiesEvent> predicate) {
        return this.getEventTimeline(adapterName, socialPage, new HashMap(), predicate);
    }

    public PagedSocialQuery getEventTimeline(String adapterName, SocialPaged socialPaged, Map commandsMap) {
        SocialAdapter socialAdapter = this.getSocialAdapter(adapterName);
        return this.getEventTimeline(socialAdapter, socialPaged, commandsMap, null);
    }

    public PagedSocialQuery getEventTimeline(String adapterName, SocialPaged socialPaged, Map commandsMap, SocialPredicate<SocialActivitiesEvent> predicate) {
        SocialAdapter socialAdapter = this.getSocialAdapter(adapterName);
        return this.getEventTimeline(socialAdapter, socialPaged, commandsMap, predicate);
    }

    public PagedSocialQuery getEventTimeline(SocialAdapter adapter, SocialPaged socialPaged, Map commandsMap, SocialPredicate<SocialActivitiesEvent> predicate) {
        socialPaged = this.setupQueryDirection(socialPaged);
        List<SocialActivitiesEvent> typeEvents = new ArrayList<SocialActivitiesEvent>();
        if (socialPaged.isANewQuery()) {
            socialPaged = this.searchForRecentEvents(adapter.socialEventType(), socialPaged, typeEvents, predicate);
        }
        if (!this.foundEnoughtEvents(socialPaged, typeEvents)) {
            socialPaged = this.searchForStoredEvents(adapter.socialEventType(), socialPaged, typeEvents, predicate);
        }
        typeEvents = this.filterTimelineWithAdapters(commandsMap, typeEvents);
        this.checkIfICanGoForward(socialPaged, typeEvents);
        PagedSocialQuery query = new PagedSocialQuery(typeEvents, socialPaged);
        return query;
    }

    SocialAdapter getSocialAdapter(String adapterName) {
        return this.socialRouterAPI.getSocialAdapter(adapterName);
    }

    private SocialPaged searchForStoredEvents(SocialEventType type, SocialPaged socialPaged, List<SocialActivitiesEvent> events, SocialPredicate<SocialActivitiesEvent> predicate) {
        if (socialPaged.firstFileRead()) {
            this.readMostRecentFile(type, socialPaged, events, predicate);
        } else {
            this.readCurrentFile(type, socialPaged, events, predicate);
        }
        if (!this.foundEnoughtEvents(socialPaged, events) && this.shouldIReadMoreFiles(socialPaged)) {
            this.readMoreFiles(socialPaged, type, events, predicate);
        }
        return socialPaged;
    }

    private boolean shouldIReadMoreFiles(SocialPaged socialPaged) {
        return socialPaged.lastFileReaded() != null && !socialPaged.lastFileReaded().isEmpty() && this.thereIsMoreFilesToRead(socialPaged.lastFileReaded());
    }

    private void readMoreFiles(SocialPaged socialPaged, SocialEventType type, List<SocialActivitiesEvent> events, SocialPredicate<SocialActivitiesEvent> predicate) {
        String nextFileToRead = socialPaged.getNextFileToRead();
        if (this.thereIsMoreFilesToRead(nextFileToRead)) {
            this.addEventsToTimeline(type, socialPaged, events, nextFileToRead, predicate);
            if (!this.foundEnoughtEvents(socialPaged, events)) {
                this.readMoreFiles(socialPaged, type, events, predicate);
            }
        }
        this.checkIfICanGoForward(socialPaged, events);
    }

    private void readCurrentFile(SocialEventType type, SocialPaged socialPaged, List<SocialActivitiesEvent> events, SocialPredicate<SocialActivitiesEvent> predicate) {
        String lastFileReaded = socialPaged.lastFileReaded();
        this.addEventsToTimeline(type, socialPaged, events, lastFileReaded, predicate);
    }

    private void addEventsToTimeline(SocialEventType type, SocialPaged socialPaged, List<SocialActivitiesEvent> events, String lastFileReaded, SocialPredicate<SocialActivitiesEvent> predicate) {
        List timeline = this.getSocialTimelinePersistenceAPI().getTimeline(type, lastFileReaded);
        List<SocialActivitiesEvent> filteredList = this.filterList(predicate, timeline);
        this.setNumberOfEventsOnFile(socialPaged, type, lastFileReaded);
        this.addEvents(socialPaged, events, filteredList);
    }

    private void setNumberOfEventsOnFile(SocialPaged socialPaged, SocialEventType type, String lastFileReaded) {
        socialPaged.setNumberOfEventsOnFile(this.getSocialTimelinePersistenceAPI().getNumberOfEventsOnFile(type, lastFileReaded));
    }

    private void readMostRecentFile(SocialEventType type, SocialPaged socialPaged, List<SocialActivitiesEvent> events, SocialPredicate<SocialActivitiesEvent> predicate) {
        Integer userMostRecentFileIndex = this.getSocialTimelinePersistenceAPI().getTypeMostRecentFileIndex(type);
        List timeline = this.getSocialTimelinePersistenceAPI().getTimeline(type, userMostRecentFileIndex.toString());
        List<SocialActivitiesEvent> filteredList = this.filterList(predicate, timeline);
        socialPaged.setLastFileReaded(userMostRecentFileIndex.toString());
        this.readEvents(socialPaged, events, filteredList);
    }

    private SocialPaged searchForRecentEvents(SocialEventType type, SocialPaged socialPaged, List<SocialActivitiesEvent> events, SocialPredicate<SocialActivitiesEvent> predicate) {
        List freshEvents = this.getSocialTimelinePersistenceAPI().getRecentEvents(type);
        List<SocialActivitiesEvent> filteredList = this.filterList(predicate, freshEvents);
        Collections.reverse(filteredList);
        this.searchEvents(socialPaged, events, filteredList);
        return socialPaged;
    }
}

