/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.server;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.persistence.SocialClusterMessaging;
import org.ext.uberfire.social.activities.persistence.SocialTimelineCacheClusterPersistence;
import org.ext.uberfire.social.activities.persistence.SocialTimelineCacheInstancePersistence;
import org.ext.uberfire.social.activities.security.SocialSecurityConstraintsManager;
import org.ext.uberfire.social.activities.server.SocialUserServicesExtendedBackEndImpl;
import org.ext.uberfire.social.activities.service.SocialEventTypeRepositoryAPI;
import org.ext.uberfire.social.activities.service.SocialTimelinePersistenceAPI;
import org.ext.uberfire.social.activities.service.SocialUserPersistenceAPI;
import org.uberfire.backend.server.io.ConfigIOServiceProducer;
import org.uberfire.commons.cluster.ClusterServiceFactory;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;

@ApplicationScoped
@Startup(value=StartupType.BOOTSTRAP)
public class SocialTimelinePersistenceProducer {
    @Inject
    @Named(value="clusterServiceFactory")
    private ClusterServiceFactory clusterServiceFactory;
    private SocialTimelinePersistenceAPI socialTimelinePersistenceAPI;
    private Gson gson;
    private Type gsonCollectionType;
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    @Named(value="systemFS")
    private FileSystem fileSystem;
    @Inject
    SocialEventTypeRepositoryAPI socialEventTypeRepository;
    @Inject
    private SocialClusterMessaging socialClusterMessaging;
    @Inject
    private SocialUserPersistenceAPI socialUserPersistenceAPI;
    @Inject
    SocialSecurityConstraintsManager socialSecurityConstraintsManager;

    @PostConstruct
    public void setup() {
        this.gsonFactory();
        IOService _ioService = this.getConfigIOServiceProducer().configIOService();
        FileSystem _fileSystem = this.getConfigIOServiceProducer().configFileSystem();
        SocialUserServicesExtendedBackEndImpl userServicesBackend = new SocialUserServicesExtendedBackEndImpl(this.fileSystem);
        this.setupSocialTimelinePersistenceAPI(_ioService, _fileSystem, userServicesBackend);
    }

    ConfigIOServiceProducer getConfigIOServiceProducer() {
        return ConfigIOServiceProducer.getInstance();
    }

    void setupSocialTimelinePersistenceAPI(IOService _ioService, FileSystem _fileSystem, SocialUserServicesExtendedBackEndImpl userServicesBackend) {
        this.socialTimelinePersistenceAPI = this.clusterServiceFactory == null ? new SocialTimelineCacheInstancePersistence(this.gson, this.gsonCollectionType, _ioService, this.socialEventTypeRepository, this.socialUserPersistenceAPI, userServicesBackend, _fileSystem, this.socialSecurityConstraintsManager) : new SocialTimelineCacheClusterPersistence(this.gson, this.gsonCollectionType, _ioService, this.socialEventTypeRepository, this.socialUserPersistenceAPI, this.socialClusterMessaging, userServicesBackend, _fileSystem, this.socialSecurityConstraintsManager);
        this.socialTimelinePersistenceAPI.setup();
    }

    @Produces
    @Named(value="socialTimelinePersistence")
    public SocialTimelinePersistenceAPI socialTimelinePersistenceAPI() {
        return this.socialTimelinePersistenceAPI;
    }

    void gsonFactory() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        this.gson = gsonBuilder.create();
        this.gsonCollectionType = new TypeToken<Collection<SocialActivitiesEvent>>(){}.getType();
    }
}

