/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.model.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.workbench.common.services.refactoring.model.index.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValuePartIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.commons.data.Pair;

public class Resource
implements IndexElementsGenerator {
    private final String resourceFQN;
    private final ResourceType resourceType;
    private final Map<String, PartType> parts;

    public Resource(String resourceFQN, ResourceType resourceType) {
        this.resourceFQN = resourceFQN;
        this.resourceType = resourceType;
        this.parts = new HashMap<String, PartType>();
    }

    public void addPart(String uniquePartName, PartType partType) {
        PartType previousPartType = this.parts.put(uniquePartName, partType);
        if (previousPartType != null) {
            throw new IllegalArgumentException(partType.toString() + " " + uniquePartName + " has already been added!");
        }
    }

    public String getResourceFQN() {
        return this.resourceFQN;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public List<Pair<String, String>> toIndexElements() {
        ArrayList<Pair<String, String>> indexElements = new ArrayList<Pair<String, String>>();
        ValueResourceIndexTerm resTerm = new ValueResourceIndexTerm(this.resourceFQN, this.resourceType);
        indexElements.add(new Pair((Object)resTerm.getTerm(), (Object)resTerm.getValue()));
        for (Map.Entry<String, PartType> part : this.parts.entrySet()) {
            ValuePartIndexTerm partTerm = new ValuePartIndexTerm(part.getKey(), part.getValue());
            indexElements.add((Pair<String, String>)new Pair((Object)partTerm.getTerm(), (Object)partTerm.getValue()));
        }
        return indexElements;
    }

    public String toString() {
        return this.resourceType.toString() + " => " + this.resourceFQN;
    }
}

