/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.builder;

import java.lang.reflect.Method;
import org.jboss.weld.interceptor.builder.BuildableInterceptionModel;
import org.jboss.weld.interceptor.builder.InterceptionModelImpl;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;

public class InterceptionModelBuilder<T, I> {
    private final BuildableInterceptionModel<T, I> interceptionModel;
    private final T interceptedEntity;

    private InterceptionModelBuilder(T interceptedEntity) {
        this.interceptedEntity = interceptedEntity;
        this.interceptionModel = new InterceptionModelImpl(interceptedEntity);
    }

    public static <T> InterceptionModelBuilder<T, ?> newBuilderFor(T entity) {
        return new InterceptionModelBuilder(entity);
    }

    public T getInterceptedEntity() {
        return this.interceptedEntity;
    }

    public InterceptionModel<T, I> build() {
        return this.interceptionModel;
    }

    public MethodInterceptorDescriptor interceptAll() {
        return new MethodInterceptorDescriptor(null, InterceptionType.values());
    }

    public MethodInterceptorDescriptor interceptAroundInvoke(Method m) {
        return this.intercept(javax.enterprise.inject.spi.InterceptionType.AROUND_INVOKE, m);
    }

    public MethodInterceptorDescriptor interceptAroundTimeout(Method m) {
        return this.intercept(javax.enterprise.inject.spi.InterceptionType.AROUND_TIMEOUT, m);
    }

    public MethodInterceptorDescriptor intercept(javax.enterprise.inject.spi.InterceptionType interceptionType, Method m) {
        InterceptionType weldInterceptionType = InterceptionType.valueOf(interceptionType);
        if (weldInterceptionType.isLifecycleCallback()) {
            throw new IllegalArgumentException("Illegal interception type: " + interceptionType);
        }
        return new MethodInterceptorDescriptor(m, weldInterceptionType);
    }

    public MethodInterceptorDescriptor interceptPostConstruct() {
        return this.intercept(javax.enterprise.inject.spi.InterceptionType.POST_CONSTRUCT);
    }

    public MethodInterceptorDescriptor interceptPreDestroy() {
        return this.intercept(javax.enterprise.inject.spi.InterceptionType.PRE_DESTROY);
    }

    public MethodInterceptorDescriptor interceptPrePassivate() {
        return this.intercept(javax.enterprise.inject.spi.InterceptionType.PRE_PASSIVATE);
    }

    public MethodInterceptorDescriptor interceptPostActivate() {
        return this.intercept(javax.enterprise.inject.spi.InterceptionType.POST_ACTIVATE);
    }

    public MethodInterceptorDescriptor intercept(javax.enterprise.inject.spi.InterceptionType interceptionType) {
        InterceptionType weldInterceptionType = InterceptionType.valueOf(interceptionType);
        if (!weldInterceptionType.isLifecycleCallback()) {
            throw new IllegalArgumentException("Illegal interception type: " + interceptionType);
        }
        return new MethodInterceptorDescriptor(null, weldInterceptionType);
    }

    public void ignoreGlobalInterceptors(Method m) {
        this.interceptionModel.setIgnoresGlobals(m, true);
    }

    public final class MethodInterceptorDescriptor {
        private final Method method;
        private final InterceptionType[] interceptionTypes;

        public MethodInterceptorDescriptor(Method m, InterceptionType ... interceptionType) {
            this.method = m;
            this.interceptionTypes = interceptionType;
        }

        public void with(InterceptorMetadata ... interceptors) {
            for (InterceptionType interceptionType : this.interceptionTypes) {
                InterceptionModelBuilder.this.interceptionModel.appendInterceptors(interceptionType, this.method, interceptors);
            }
        }
    }
}

