/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.lang.annotation.Annotation;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.weld.Container;
import org.jboss.weld.context.BoundContext;
import org.jboss.weld.context.ManagedContext;
import org.jboss.weld.context.cache.RequestScopedBeanCache;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ServletMessage;
import org.jboss.weld.servlet.api.helpers.AbstractServletListener;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

public class WeldListener
extends AbstractServletListener {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.SERVLET);
    private static final XLogger xLog = LoggerFactory.loggerFactory().getXLogger(Category.SERVLET);
    public static final String CONTEXT_IGNORE_FORWARD = "org.jboss.weld.context.ignore.forward";
    public static final String CONTEXT_IGNORE_INCLUDE = "org.jboss.weld.context.ignore.include";
    public static final String CONTEXT_IGNORE_GUARD = "org.jboss.weld.context.ignore.guard";
    private static final String INCLUDE_HEADER = "javax.servlet.include.request_uri";
    private static final String FORWARD_HEADER = "javax.servlet.forward.request_uri";
    private static final String GUARD_PARAMETER_NAME = "org.jboss.weld.context.ignore.guard.marker";
    private static final Object GUARD_PARAMETER_VALUE = new Object();
    private boolean ignoreForwards;
    private boolean ignoreIncludes;
    private boolean nestedInvocationGuardEnabled;
    private transient HttpSessionContext sessionContextCache;
    private transient HttpRequestContext requestContextCache;
    private transient HttpConversationContext conversationContextCache;
    private static final ThreadLocal<Counter> nestedInvocationGuard = new ThreadLocal();

    private HttpSessionContext sessionContext() {
        if (this.sessionContextCache == null) {
            this.sessionContextCache = (HttpSessionContext)Container.instance().deploymentManager().instance().select(HttpSessionContext.class, new Annotation[0]).get();
        }
        return this.sessionContextCache;
    }

    private HttpRequestContext requestContext() {
        if (this.requestContextCache == null) {
            this.requestContextCache = (HttpRequestContext)Container.instance().deploymentManager().instance().select(HttpRequestContext.class, new Annotation[0]).get();
        }
        return this.requestContextCache;
    }

    private HttpConversationContext conversationContext() {
        if (this.conversationContextCache == null) {
            this.conversationContextCache = (HttpConversationContext)Container.instance().deploymentManager().instance().select(HttpConversationContext.class, new Annotation[0]).get();
        }
        return this.conversationContextCache;
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (Container.available()) {
            this.sessionContext().destroy(event.getSession());
            RequestScopedBeanCache.endRequest();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void requestDestroyed(ServletRequestEvent event) {
        if (this.nestedInvocationGuardEnabled) {
            Counter counter = nestedInvocationGuard.get();
            if (counter != null) {
                counter.value--;
                if (counter.value > 0) {
                    return;
                }
                nestedInvocationGuard.remove();
                event.getServletRequest().removeAttribute(GUARD_PARAMETER_NAME);
            } else {
                log.warn((Enum)ServletMessage.GUARD_NOT_SET, new Object[0]);
                return;
            }
        }
        if (this.ignoreForwards && this.isForwardedRequest(event.getServletRequest())) {
            return;
        }
        if (this.ignoreIncludes && this.isIncludedRequest(event.getServletRequest())) {
            return;
        }
        log.trace((Enum)ServletMessage.REQUEST_DESTROYED, new Object[]{event.getServletRequest()});
        if (!Container.available()) return;
        if (!(event.getServletRequest() instanceof HttpServletRequest)) throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        try {
            this.requestContext().invalidate();
            this.safelyDeactivate((ManagedContext)this.requestContext(), request);
            this.safelyDeactivate((ManagedContext)this.sessionContext(), request);
            if (!this.conversationContext().isActive()) return;
            this.safelyDeactivate((ManagedContext)this.conversationContext(), request);
            return;
        }
        finally {
            this.safelyDissociate((BoundContext)this.requestContext(), (Object)request);
            this.safelyDissociate((BoundContext)this.sessionContext(), (Object)request);
            this.safelyDissociate((BoundContext)this.conversationContext(), (Object)request);
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        if (this.nestedInvocationGuardEnabled) {
            Counter counter = nestedInvocationGuard.get();
            Object marker = event.getServletRequest().getAttribute(GUARD_PARAMETER_NAME);
            if (counter != null && marker != null) {
                counter.value++;
                return;
            }
            if (counter != null && marker == null) {
                log.warn((Enum)ServletMessage.GUARD_LEAKED, new Object[]{counter.value});
            }
            nestedInvocationGuard.set(new Counter());
            event.getServletRequest().setAttribute(GUARD_PARAMETER_NAME, GUARD_PARAMETER_VALUE);
        }
        if (this.ignoreForwards && this.isForwardedRequest(event.getServletRequest())) {
            return;
        }
        if (this.ignoreIncludes && this.isIncludedRequest(event.getServletRequest())) {
            return;
        }
        log.trace((Enum)ServletMessage.REQUEST_INITIALIZED, new Object[]{event.getServletRequest()});
        if (Container.available()) {
            if (event.getServletRequest() instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
                this.requestContext().associate((Object)request);
                this.sessionContext().associate((Object)request);
                this.conversationContext().associate((Object)request);
                this.requestContext().activate();
                this.sessionContext().activate();
            } else {
                throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
            }
        }
    }

    private boolean isIncludedRequest(ServletRequest request) {
        return request.getAttribute(INCLUDE_HEADER) != null;
    }

    private boolean isForwardedRequest(ServletRequest request) {
        return request.getAttribute(FORWARD_HEADER) != null;
    }

    public void contextInitialized(ServletContextEvent sce) {
        this.ignoreForwards = this.getBooleanInitParameter(sce.getServletContext(), CONTEXT_IGNORE_FORWARD, false);
        this.ignoreIncludes = this.getBooleanInitParameter(sce.getServletContext(), CONTEXT_IGNORE_INCLUDE, false);
        this.nestedInvocationGuardEnabled = this.getBooleanInitParameter(sce.getServletContext(), CONTEXT_IGNORE_GUARD, true);
    }

    private boolean getBooleanInitParameter(ServletContext ctx, String parameterName, boolean defaultValue) {
        String value = ctx.getInitParameter(parameterName);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    private <T> void safelyDissociate(BoundContext<T> context, T storage) {
        try {
            context.dissociate(storage);
        }
        catch (Exception e) {
            log.warn((Enum)ServletMessage.UNABLE_TO_DISSOCIATE_CONTEXT, new Object[]{context, storage});
            xLog.throwing(XLogger.Level.DEBUG, (Throwable)e);
        }
    }

    private void safelyDeactivate(ManagedContext context, HttpServletRequest request) {
        try {
            context.deactivate();
        }
        catch (Exception e) {
            log.warn((Enum)ServletMessage.UNABLE_TO_DEACTIVATE_CONTEXT, new Object[]{context, request});
            xLog.throwing(XLogger.Level.DEBUG, (Throwable)e);
        }
    }

    private static class Counter {
        private int value = 1;

        private Counter() {
        }
    }
}

