/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.rules;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassWalker {
    public static Set<Class> findClassesInPackage(String packageName, ClassLoader loader) {
        HashSet<Class> acceptedClasses = new HashSet<Class>();
        try {
            String packageOnly = packageName;
            boolean recursive = false;
            if (packageName.endsWith(".*")) {
                packageOnly = packageName.substring(0, packageName.lastIndexOf(".*"));
                recursive = true;
            }
            String packageDirName = packageOnly.replace('.', '/');
            Enumeration<URL> dirs = loader.getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                if ("file".equals(url.getProtocol())) {
                    ClassWalker.findClassesInDirPackage(packageOnly, URLDecoder.decode(url.getFile(), "UTF-8"), recursive, acceptedClasses, loader);
                    continue;
                }
                if (!"jar".equals(url.getProtocol())) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (name.endsWith("/")) continue;
                    String className = name.replaceAll("/", ".").replaceAll("\\.class", "");
                    ClassWalker.checkValidClass(className, acceptedClasses, loader);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return acceptedClasses;
    }

    private static void checkValidClass(String className, Set<Class> acceptedClasses, ClassLoader loader) {
        try {
            Class<?> classClass = loader.loadClass(className);
            acceptedClasses.add(classClass);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private static void findClassesInDirPackage(String packageName, String packagePath, final boolean recursive, Set<Class> classes, ClassLoader loader) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ClassWalker.findClassesInDirPackage(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes, loader);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            ClassWalker.checkValidClass(packageName + "." + className, classes, loader);
        }
    }
}

