/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util.upgrade;

import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.server.util.upgrade.IUpgradeHelper;

public class RuleModelUpgradeHelper2
implements IUpgradeHelper<RuleModel, RuleModel> {
    @Override
    public RuleModel upgrade(RuleModel model) {
        this.updateConnectiveConstraints(model);
        return model;
    }

    private void updateConnectiveConstraints(RuleModel model) {
        for (IPattern p : model.lhs) {
            this.fixConnectiveConstraints(p);
        }
    }

    private void fixConnectiveConstraints(IPattern p) {
        if (p instanceof FactPattern) {
            this.fixConnectiveConstraints((FactPattern)p);
        } else if (p instanceof CompositeFactPattern) {
            this.fixConnectiveConstraints((CompositeFactPattern)p);
        }
    }

    private void fixConnectiveConstraints(FactPattern p) {
        for (FieldConstraint fc : p.getFieldConstraints()) {
            this.fixConnectiveConstraints(fc);
        }
    }

    private void fixConnectiveConstraints(CompositeFactPattern p) {
        for (IFactPattern sp : p.getPatterns()) {
            this.fixConnectiveConstraints(sp);
        }
    }

    private void fixConnectiveConstraints(FieldConstraint fc) {
        if (fc instanceof SingleFieldConstraint) {
            this.fixConnectiveConstraints((SingleFieldConstraint)fc);
        } else if (fc instanceof CompositeFieldConstraint) {
            this.fixConnectiveConstraints((CompositeFieldConstraint)fc);
        }
    }

    private void fixConnectiveConstraints(SingleFieldConstraint sfc) {
        if (sfc.connectives == null) {
            return;
        }
        for (ConnectiveConstraint cc : sfc.connectives) {
            if (cc.getFieldName() != null) continue;
            cc.setFieldName(sfc.getFieldName());
            cc.setFieldType(sfc.getFieldType());
        }
    }

    private void fixConnectiveConstraints(CompositeFieldConstraint cfc) {
        if (cfc.constraints == null) {
            return;
        }
        for (FieldConstraint fc : cfc.constraints) {
            this.fixConnectiveConstraints(fc);
        }
    }
}

