/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugins;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.plugin.RuntimePlugin;
import org.uberfire.backend.plugin.RuntimePluginProcessor;
import org.uberfire.backend.plugin.RuntimePluginService;
import org.uberfire.backend.server.plugins.PluginUtils;
import org.uberfire.backend.server.plugins.processors.HTMLPluginProcessor;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;

@Service
@ApplicationScoped
@Startup(value=StartupType.BOOTSTRAP)
public class RuntimePluginServiceImpl
implements RuntimePluginService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimePluginServiceImpl.class);
    @Inject
    @Any
    Instance<RuntimePluginProcessor> runtimePluginProcessors;
    @Inject
    HTMLPluginProcessor htmlPluginProcessor;

    public Collection<String> listFrameworksContent() {
        return this.directoryContent("frameworks", "*.js");
    }

    public Collection<String> listPluginsContent() {
        return this.directoryContent("plugins", "*.js");
    }

    public String getTemplateContent(String url) {
        String pluginTemplateContent = this.getRuntimePluginTemplateContent(url);
        if (this.isAJarPluginTemplate(pluginTemplateContent)) {
            return pluginTemplateContent;
        }
        String realPath = PluginUtils.getRealPath("plugins");
        if (realPath == null) {
            LOGGER.info("Not fetching template content for " + url + " because getRealPath() is returning null. (This app is probably deployed in an unexploded .war)");
            return "";
        }
        Path template = url.startsWith("/") ? Paths.get((URI)URI.create("file://" + realPath + url)) : Paths.get((URI)URI.create("file://" + realPath + "/" + url));
        if (Files.isRegularFile((Path)template, (LinkOption[])new LinkOption[0])) {
            return new String(Files.readAllBytes((Path)template));
        }
        return "";
    }

    private boolean isAJarPluginTemplate(String pluginContent) {
        return pluginContent != null && !pluginContent.isEmpty();
    }

    private Collection<String> directoryContent(String directory, String glob) {
        String realPath = PluginUtils.getRealPath(directory);
        if (realPath == null) {
            LOGGER.info("Not listing directory content for " + directory + "/" + glob + " because getRealPath() is returning null. (This app is probably deployed in an unexploded .war)");
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Path pluginsRootPath = Paths.get((URI)URI.create("file://" + realPath));
        if (Files.isDirectory((Path)pluginsRootPath, (LinkOption[])new LinkOption[0])) {
            DirectoryStream stream = Files.newDirectoryStream((Path)pluginsRootPath, (String)glob);
            for (Path activeJS : stream) {
                result.add(new String(Files.readAllBytes((Path)activeJS)));
            }
        }
        return result;
    }

    public String getRuntimePluginTemplateContent(String pluginName) {
        if (this.htmlPluginProcessor.isRegistered(pluginName)) {
            Optional<RuntimePlugin> runtimePlugin = this.htmlPluginProcessor.lookupForTemplate(pluginName);
            return runtimePlugin.map(p -> p.getPluginContent()).orElse("");
        }
        return "";
    }

    public List<RuntimePlugin> getRuntimePlugins() {
        ArrayList<RuntimePlugin> runtimePlugins = new ArrayList<RuntimePlugin>();
        this.runtimePluginProcessors.forEach(p -> runtimePlugins.addAll(p.getAvailableRuntimePlugins()));
        return runtimePlugins;
    }
}

