/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugins.processors;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jboss.errai.cdi.server.scripts.ScriptRegistry;
import org.uberfire.backend.plugin.PluginProcessor;
import org.uberfire.workbench.events.PluginAddedEvent;
import org.uberfire.workbench.events.PluginUpdatedEvent;

@ApplicationScoped
public class GWTScriptPluginProcessor
implements PluginProcessor {
    final Set<String> availablePlugins = new HashSet<String>();
    static final String SCRIPT_REGISTRY_KEY = "UF";
    private ScriptRegistry scriptRegistry;
    private Event<PluginAddedEvent> pluginAddedEvent;
    private Event<PluginUpdatedEvent> pluginUpdatedEvent;

    public GWTScriptPluginProcessor() {
    }

    @Inject
    public GWTScriptPluginProcessor(ScriptRegistry scriptRegistry, Event<PluginAddedEvent> pluginAddedEvent, Event<PluginUpdatedEvent> pluginUpdatedEvent) {
        this.scriptRegistry = scriptRegistry;
        this.pluginAddedEvent = pluginAddedEvent;
        this.pluginUpdatedEvent = pluginUpdatedEvent;
    }

    @PreDestroy
    void shutDown() {
        this.scriptRegistry.removeScripts(SCRIPT_REGISTRY_KEY);
    }

    private void add(String pluginName, String scriptUrl) {
        this.availablePlugins.add(pluginName);
        this.scriptRegistry.addScript(SCRIPT_REGISTRY_KEY, scriptUrl);
    }

    public void removeAll() {
        this.availablePlugins.clear();
        this.scriptRegistry.removeScripts(SCRIPT_REGISTRY_KEY);
    }

    public boolean isRegistered(String pluginName) {
        return this.availablePlugins.contains(pluginName);
    }

    public boolean shouldProcess(String pluginName) {
        return pluginName.endsWith(PluginProcessor.PluginProcessorType.GWT.getExtension());
    }

    public void process(String pluginName, String pluginDeploymentDir, boolean notifyClients) {
        String pluginDisplayName = pluginName.replace(PluginProcessor.PluginProcessorType.GWT.getExtension(), "");
        if (!this.isRegistered(pluginName)) {
            String url = this.resolveScriptUrl(pluginName, pluginDeploymentDir);
            this.add(pluginName, url);
            if (notifyClients) {
                this.pluginAddedEvent.fire((Object)new PluginAddedEvent(pluginDisplayName));
            }
        } else if (notifyClients) {
            this.pluginUpdatedEvent.fire((Object)new PluginUpdatedEvent(pluginDisplayName));
        }
    }

    String resolveScriptUrl(String pluginName, String pluginDeploymentDir) {
        String pluginsDeploymentUrlPath = StringUtils.substringAfterLast((String)pluginDeploymentDir, (String)File.separator);
        return pluginsDeploymentUrlPath + "/" + pluginName + "?nocache=" + System.currentTimeMillis();
    }
}

