/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;

final class StandardDefinitions {
    static final String GREENWICH = "8901";

    private StandardDefinitions() {
    }

    private static Map<String, Object> properties(short s, String string, String string2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(8);
        hashMap.put("identifiers", new NamedIdentifier(Citations.EPSG, String.valueOf(s)));
        hashMap.put("name", new NamedIdentifier(Citations.EPSG, string));
        hashMap.put("alias", string2);
        if (bl) {
            hashMap.put("domainOfValidity", Extents.WORLD);
        }
        return hashMap;
    }

    static GeographicCRS createGeographicCRS(short s, GeodeticDatum geodeticDatum, EllipsoidalCS ellipsoidalCS) {
        String string;
        String string2 = null;
        boolean bl = false;
        switch (s) {
            case 4326: {
                string = "WGS 84";
                bl = true;
                break;
            }
            case 4322: {
                string = "WGS 72";
                bl = true;
                break;
            }
            case 4258: {
                string = "ETRS89";
                string2 = "ETRS89-GRS80";
                break;
            }
            case 4269: {
                string = "NAD83";
                break;
            }
            case 4267: {
                string = "NAD27";
                break;
            }
            case 4230: {
                string = "ED50";
                break;
            }
            case 4047: {
                string = "Unspecified datum based upon the GRS 1980 Authalic Sphere";
                bl = true;
                break;
            }
            default: {
                throw new AssertionError(s);
            }
        }
        return new DefaultGeographicCRS(StandardDefinitions.properties(s, string, string2, bl), geodeticDatum, ellipsoidalCS);
    }

    static GeodeticDatum createGeodeticDatum(short s, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        String string;
        String string2;
        boolean bl = false;
        switch (s) {
            case 6326: {
                string2 = "World Geodetic System 1984";
                string = "WGS 84";
                bl = true;
                break;
            }
            case 6322: {
                string2 = "World Geodetic System 1972";
                string = "WGS 72";
                bl = true;
                break;
            }
            case 6258: {
                string2 = "European Terrestrial Reference System 1989";
                string = "ETRS89";
                break;
            }
            case 6269: {
                string2 = "North American Datum 1983";
                string = "NAD83";
                break;
            }
            case 6267: {
                string2 = "North American Datum 1927";
                string = "NAD27";
                break;
            }
            case 6230: {
                string2 = "European Datum 1950";
                string = "ED50";
                break;
            }
            case 6047: {
                string2 = "Not specified (based on GRS 1980 Authalic Sphere)";
                string = null;
                bl = true;
                break;
            }
            default: {
                throw new AssertionError(s);
            }
        }
        return new DefaultGeodeticDatum(StandardDefinitions.properties(s, string2, string, bl), ellipsoid, primeMeridian);
    }

    static Ellipsoid createEllipsoid(short s) {
        double d;
        double d2;
        String string;
        String string2 = null;
        boolean bl = true;
        BaseUnit baseUnit = SI.METRE;
        switch (s) {
            case 7030: {
                string = "WGS 84";
                string2 = "WGS84";
                d2 = 6378137.0;
                d = 298.257223563;
                break;
            }
            case 7043: {
                string = "WGS 72";
                string2 = "NWL 10D";
                d2 = 6378135.0;
                d = 298.26;
                break;
            }
            case 7019: {
                string2 = "International 1979";
                string = "GRS 1980";
                d2 = 6378137.0;
                d = 298.257222101;
                break;
            }
            case 7022: {
                string = "International 1924";
                string2 = "Hayford 1909";
                d2 = 6378388.0;
                d = 297.0;
                break;
            }
            case 7008: {
                string = "Clarke 1866";
                bl = false;
                d2 = 6378206.4;
                d = 6356583.8;
                break;
            }
            case 7048: {
                string = "GRS 1980 Authalic Sphere";
                bl = false;
                d = 6371007.0;
                d2 = 6371007.0;
                break;
            }
            default: {
                throw new AssertionError(s);
            }
        }
        Map<String, Object> map = StandardDefinitions.properties(s, string, string2, false);
        if (bl) {
            return DefaultEllipsoid.createFlattenedSphere(map, d2, d, (Unit<Length>)baseUnit);
        }
        return DefaultEllipsoid.createEllipsoid(map, d2, d, (Unit<Length>)baseUnit);
    }

    static PrimeMeridian primeMeridian() {
        HashMap<String, NamedIdentifier> hashMap = new HashMap<String, NamedIdentifier>(4);
        hashMap.put("name", new NamedIdentifier(Citations.EPSG, "Greenwich"));
        hashMap.put("identifiers", new NamedIdentifier(Citations.EPSG, GREENWICH));
        return new DefaultPrimeMeridian(hashMap, 0.0, (Unit<Angle>)NonSI.DEGREE_ANGLE);
    }

    static VerticalCRS createVerticalCRS(short s, VerticalDatum verticalDatum) {
        short s2;
        short s3;
        String string;
        String string2;
        String string3;
        switch (s) {
            case 5714: {
                string3 = "MSL height";
                string2 = "mean sea level height";
                string = "Vertical CS. Axis: height (H).";
                s3 = 6499;
                s2 = 114;
                break;
            }
            case 5715: {
                string3 = "MSL depth";
                string2 = "mean sea level depth";
                string = "Vertical CS. Axis: depth (D).";
                s3 = 6498;
                s2 = 113;
                break;
            }
            default: {
                throw new AssertionError(s);
            }
        }
        return new DefaultVerticalCRS(StandardDefinitions.properties(s, string3, string2, true), verticalDatum, new DefaultVerticalCS(StandardDefinitions.properties(s3, string, null, false), StandardDefinitions.createAxis(s2)));
    }

    static VerticalDatum createVerticalDatum(short s) {
        String string;
        String string2;
        switch (s) {
            case 5100: {
                string2 = "Mean Sea Level";
                string = "MSL";
                break;
            }
            default: {
                throw new AssertionError(s);
            }
        }
        return new DefaultVerticalDatum(StandardDefinitions.properties(s, string2, string, true), VerticalDatumType.GEOIDAL);
    }

    static CoordinateSystem createCoordinateSystem(short s) {
        short s2;
        int n;
        String string;
        boolean bl = false;
        switch (s) {
            case 6422: {
                string = "Ellipsoidal 2D";
                n = 2;
                s2 = 108;
                break;
            }
            case 6423: {
                string = "Ellipsoidal 3D";
                n = 3;
                s2 = 111;
                break;
            }
            case 6500: {
                string = "Earth centred";
                n = 3;
                s2 = 118;
                bl = true;
                break;
            }
            default: {
                throw new AssertionError(s);
            }
        }
        Map<String, Object> map = StandardDefinitions.properties(s, string, null, false);
        CoordinateSystemAxis coordinateSystemAxis = null;
        CoordinateSystemAxis coordinateSystemAxis2 = null;
        CoordinateSystemAxis coordinateSystemAxis3 = null;
        switch (n) {
            default: {
                throw new AssertionError(n);
            }
            case 3: {
                s2 = (short)(s2 - 1);
                coordinateSystemAxis3 = StandardDefinitions.createAxis(s2);
            }
            case 2: {
                s2 = (short)(s2 - 1);
                coordinateSystemAxis2 = StandardDefinitions.createAxis(s2);
            }
            case 1: {
                s2 = (short)(s2 - 1);
                coordinateSystemAxis = StandardDefinitions.createAxis(s2);
            }
            case 0: 
        }
        if (bl) {
            return new DefaultCartesianCS((Map<String, ?>)map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        if (coordinateSystemAxis3 != null) {
            return new DefaultEllipsoidalCS((Map<String, ?>)map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        return new DefaultEllipsoidalCS((Map<String, ?>)map, coordinateSystemAxis, coordinateSystemAxis2);
    }

    static CoordinateSystemAxis createAxis(short s) {
        AxisDirection axisDirection;
        String string;
        String string2;
        BaseUnit baseUnit = SI.METRE;
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        RangeMeaning rangeMeaning = null;
        switch (s) {
            case 106: 
            case 108: {
                string2 = "Geodetic latitude";
                string = "\u03c6";
                baseUnit = NonSI.DEGREE_ANGLE;
                axisDirection = AxisDirection.NORTH;
                d = -90.0;
                d2 = 90.0;
                rangeMeaning = RangeMeaning.EXACT;
                break;
            }
            case 107: 
            case 109: {
                string2 = "Geodetic longitude";
                string = "\u03bb";
                baseUnit = NonSI.DEGREE_ANGLE;
                axisDirection = AxisDirection.EAST;
                d = -180.0;
                d2 = 180.0;
                rangeMeaning = RangeMeaning.WRAPAROUND;
                break;
            }
            case 110: {
                string2 = "Ellipsoidal height";
                string = "h";
                axisDirection = AxisDirection.UP;
                break;
            }
            case 114: {
                string2 = "Gravity-related height";
                string = "H";
                axisDirection = AxisDirection.UP;
                break;
            }
            case 113: {
                string2 = "Depth";
                string = "D";
                axisDirection = AxisDirection.DOWN;
                break;
            }
            case 115: {
                string2 = "Geocentric X";
                string = "X";
                axisDirection = AxisDirection.GEOCENTRIC_X;
                break;
            }
            case 116: {
                string2 = "Geocentric Y";
                string = "Y";
                axisDirection = AxisDirection.GEOCENTRIC_Y;
                break;
            }
            case 117: {
                string2 = "Geocentric Z";
                string = "Z";
                axisDirection = AxisDirection.GEOCENTRIC_Z;
                break;
            }
            default: {
                throw new AssertionError(s);
            }
        }
        Map<String, Object> map = StandardDefinitions.properties(s, string2, null, false);
        map.put("minimumValue", d);
        map.put("maximumValue", d2);
        map.put("rangeMeaning", rangeMeaning);
        return new DefaultCoordinateSystemAxis(map, string, axisDirection, (Unit<?>)baseUnit);
    }
}

