/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.ConstantTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.LogarithmicTransform1D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PowerTransform1D;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;

final class ExponentialTransform1D
extends AbstractMathTransform1D
implements Serializable {
    private static final long serialVersionUID = 5331178990358868947L;
    final double base;
    final double lnBase;
    final double scale;
    private MathTransform1D inverse;

    ExponentialTransform1D(LogarithmicTransform1D logarithmicTransform1D) {
        this.base = logarithmicTransform1D.base();
        this.lnBase = logarithmicTransform1D.lnBase();
        this.scale = logarithmicTransform1D.pow(-logarithmicTransform1D.offset());
        this.inverse = logarithmicTransform1D;
    }

    protected ExponentialTransform1D(double d, double d2) {
        this.base = d;
        this.scale = d2;
        this.lnBase = Math.log(d);
    }

    public static MathTransform1D create(double d, double d2) {
        if (d == 0.0 || d2 == 0.0) {
            return ConstantTransform1D.ZERO;
        }
        if (d == 1.0) {
            return LinearTransform1D.create(d2, 0.0);
        }
        return new ExponentialTransform1D(d, d2);
    }

    @Override
    public synchronized MathTransform1D inverse() {
        if (this.inverse == null) {
            this.inverse = LogarithmicTransform1D.create(this);
        }
        return this.inverse;
    }

    @Override
    public double derivative(double d) {
        return this.lnBase * this.transform(d);
    }

    @Override
    public double transform(double d) {
        return this.scale * Math.pow(this.base, d);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray != dArray2 || n >= n2) {
            while (--n3 >= 0) {
                dArray2[n2++] = this.scale * Math.pow(this.base, dArray[n++]);
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                dArray2[--n2] = this.scale * Math.pow(this.base, dArray[--n]);
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray != fArray2 || n >= n2) {
            while (--n3 >= 0) {
                fArray2[n2++] = (float)(this.scale * Math.pow(this.base, fArray[n++]));
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                fArray2[--n2] = (float)(this.scale * Math.pow(this.base, fArray[--n]));
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        while (--n3 >= 0) {
            fArray[n2++] = (float)(this.scale * Math.pow(this.base, dArray[n++]));
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        while (--n3 >= 0) {
            dArray[n2++] = this.scale * Math.pow(this.base, fArray[n++]);
        }
    }

    @Override
    final MathTransform concatenate(MathTransform mathTransform, boolean bl) {
        if (mathTransform instanceof LinearTransform) {
            LinearTransform1D linearTransform1D = (LinearTransform1D)mathTransform;
            if (bl) {
                double d = Math.pow(this.base, linearTransform1D.scale);
                double d2 = Math.pow(this.base, linearTransform1D.offset) * this.scale;
                if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                    return ExponentialTransform1D.create(d, d2);
                }
            } else if (linearTransform1D.offset == 0.0) {
                return ExponentialTransform1D.create(this.base, this.scale * linearTransform1D.scale);
            }
        } else if (mathTransform instanceof LogarithmicTransform1D) {
            return this.concatenateLog((LogarithmicTransform1D)mathTransform, bl);
        }
        return super.concatenate(mathTransform, bl);
    }

    final MathTransform concatenateLog(LogarithmicTransform1D logarithmicTransform1D, boolean bl) {
        double d = this.lnBase / logarithmicTransform1D.lnBase();
        if (bl) {
            return MathTransforms.concatenate(PowerTransform1D.create(d), LinearTransform1D.create(this.scale * Math.pow(this.base, logarithmicTransform1D.offset()), 0.0));
        }
        double d2 = this.scale > 0.0 ? logarithmicTransform1D.log(this.scale) + logarithmicTransform1D.offset() : logarithmicTransform1D.log(this.scale * logarithmicTransform1D.offset() * logarithmicTransform1D.lnBase());
        if (!Double.isNaN(d2)) {
            return LinearTransform1D.create(d, d2);
        }
        return null;
    }

    @Override
    protected int computeHashCode() {
        return Numerics.hashCode(Double.doubleToLongBits(this.base) + 31L * Double.doubleToLongBits(this.scale)) ^ super.computeHashCode();
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            ExponentialTransform1D exponentialTransform1D = (ExponentialTransform1D)object;
            return Numerics.equals(this.base, exponentialTransform1D.base) && Numerics.equals(this.scale, exponentialTransform1D.scale);
        }
        return false;
    }
}

