/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management.picketlink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.persistence.Entity;
import org.jboss.seam.security.annotations.management.IdentityEntity;
import org.jboss.seam.security.management.picketlink.IdentityStoreConfiguration;
import org.jboss.seam.security.management.picketlink.JpaIdentityStore;
import org.picketlink.idm.impl.configuration.metadata.IdentityStoreConfigurationMetaDataImpl;

@ApplicationScoped
public class JpaIdentityStoreConfiguration
extends IdentityStoreConfiguration
implements Extension {
    private Class<?> identityClass;
    private Class<?> credentialClass;
    private Class<?> relationshipClass;
    private Class<?> roleTypeClass;
    private Class<?> attributeClass;

    public <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event, BeanManager beanManager) {
        AnnotatedType type;
        if (event.getAnnotatedType().isAnnotationPresent(Entity.class) && (type = event.getAnnotatedType()).isAnnotationPresent(IdentityEntity.class)) {
            IdentityEntity a = (IdentityEntity)type.getAnnotation(IdentityEntity.class);
            switch (a.value()) {
                case IDENTITY_OBJECT: {
                    this.identityClass = type.getJavaClass();
                    break;
                }
                case IDENTITY_CREDENTIAL: {
                    this.credentialClass = type.getJavaClass();
                    break;
                }
                case IDENTITY_RELATIONSHIP: {
                    this.relationshipClass = type.getJavaClass();
                    break;
                }
                case IDENTITY_ATTRIBUTE: {
                    this.attributeClass = type.getJavaClass();
                    break;
                }
                case IDENTITY_ROLE_NAME: {
                    this.roleTypeClass = type.getJavaClass();
                }
            }
        }
    }

    @Override
    public String getId() {
        return super.getId() == null ? "jpa" : super.getId();
    }

    @Override
    public Class<?> getIdentityStoreClass() {
        return super.getIdentityStoreClass() == null ? JpaIdentityStore.class : super.getIdentityStoreClass();
    }

    public Class<?> getIdentityClass() {
        return this.identityClass;
    }

    public void setIdentityClass(Class<?> identityClass) {
        this.identityClass = identityClass;
    }

    public Class<?> getCredentialClass() {
        return this.credentialClass;
    }

    public void setCredentialClass(Class<?> credentialClass) {
        this.credentialClass = credentialClass;
    }

    public Class<?> getRelationshipClass() {
        return this.relationshipClass;
    }

    public void setRelationshipClass(Class<?> relationshipClass) {
        this.relationshipClass = relationshipClass;
    }

    public Class<?> getRoleTypeClass() {
        return this.roleTypeClass;
    }

    public void setRoleTypeClass(Class<?> roleTypeClass) {
        this.roleTypeClass = roleTypeClass;
    }

    public Class<?> getAttributeClass() {
        return this.attributeClass;
    }

    public void setAttributeClass(Class<?> attributeClass) {
        this.attributeClass = attributeClass;
    }

    @Override
    public void doConfigure(IdentityStoreConfigurationMetaDataImpl store) {
        HashMap<String, List<String>> options = new HashMap<String, List<String>>();
        if (this.identityClass != null) {
            options.put("identityEntityClassName", this.createOptionList(this.identityClass.getName()));
        }
        if (this.credentialClass != null) {
            options.put("credentialEntityClassName", this.createOptionList(this.credentialClass.getName()));
        }
        if (this.relationshipClass != null) {
            options.put("relationshipEntityClassName", this.createOptionList(this.relationshipClass.getName()));
        }
        if (this.roleTypeClass != null) {
            options.put("roleTypeEntityClassName", this.createOptionList(this.roleTypeClass.getName()));
        }
        if (this.attributeClass != null) {
            options.put("attributeEntityClassName", this.createOptionList(this.attributeClass.getName()));
        }
        store.setOptions(options);
    }

    @Override
    public boolean isConfigured() {
        return this.identityClass != null;
    }

    private List<String> createOptionList(String ... values) {
        ArrayList<String> vals = new ArrayList<String>();
        for (String v : values) {
            vals.add(v);
        }
        return vals;
    }
}

