/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.interceptor.Interceptor;
import org.jboss.weld.util.collections.ImmutableList;

class WeldVetoExtension
implements Extension {
    private Pattern vetoAnnotatedTypePattern;
    protected List<Class<? extends Annotation>> beanDefiningAnnotations;
    protected List<Class<? extends Annotation>> metaAnnotations;

    WeldVetoExtension(String regex) {
        this.vetoAnnotatedTypePattern = Pattern.compile(regex);
        this.metaAnnotations = ImmutableList.of(new Class[]{Stereotype.class, NormalScope.class});
        this.beanDefiningAnnotations = ImmutableList.of(new Class[]{Dependent.class, RequestScoped.class, ConversationScoped.class, SessionScoped.class, ApplicationScoped.class, Interceptor.class, Decorator.class, Model.class});
    }

    void processAnnotatedType(@Observes ProcessAnnotatedType<?> event) {
        if (this.vetoAnnotatedTypePattern.matcher(event.getAnnotatedType().getJavaClass().getName()).matches() && !this.hasBeanDefiningAnnotation(event.getAnnotatedType())) {
            event.veto();
        }
    }

    void cleanupAfterBoot(@Observes AfterDeploymentValidation event) {
        this.vetoAnnotatedTypePattern = null;
        this.beanDefiningAnnotations = null;
        this.metaAnnotations = null;
    }

    private boolean hasBeanDefiningAnnotation(AnnotatedType<?> annotatedType) {
        for (Class<? extends Annotation> beanDefiningAnnotation : this.beanDefiningAnnotations) {
            if (!annotatedType.isAnnotationPresent(beanDefiningAnnotation)) continue;
            return true;
        }
        for (Class<? extends Annotation> metaAnnotation : this.metaAnnotations) {
            if (!this.hasBeanDefiningMetaAnnotationSpecified(annotatedType.getAnnotations(), metaAnnotation)) continue;
            return true;
        }
        return false;
    }

    private boolean hasBeanDefiningMetaAnnotationSpecified(Set<Annotation> annotations, Class<? extends Annotation> metaAnnotationType) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(metaAnnotationType)) continue;
            return true;
        }
        return false;
    }
}

