/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Partition;
import org.apache.helix.model.StateModelDefinition;
import org.apache.log4j.Logger;

public class ConstraintBasedAssignment {
    private static Logger logger = Logger.getLogger(ConstraintBasedAssignment.class);

    public static List<String> getPreferenceList(ClusterDataCache cache, Partition partition, IdealState idealState, StateModelDefinition stateModelDef) {
        List<String> listField = idealState.getPreferenceList(partition.getPartitionName());
        if (listField != null && listField.size() == 1 && HelixConstants.StateModelToken.ANY_LIVEINSTANCE.toString().equals(listField.get(0))) {
            Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
            ArrayList<String> prefList = new ArrayList<String>(liveInstances.keySet());
            Collections.sort(prefList);
            return prefList;
        }
        return listField;
    }

    public static Map<String, String> computeAutoBestStateForPartition(ClusterDataCache cache, StateModelDefinition stateModelDef, List<String> instancePreferenceList, Map<String, String> currentStateMap, Set<String> disabledInstancesForPartition, boolean isResourceEnabled) {
        HashMap<String, String> instanceStateMap = new HashMap<String, String>();
        if (currentStateMap != null) {
            for (String instance : currentStateMap.keySet()) {
                if (!(instancePreferenceList != null && instancePreferenceList.contains(instance) || disabledInstancesForPartition.contains(instance))) {
                    instanceStateMap.put(instance, HelixDefinedState.DROPPED.toString());
                    continue;
                }
                if (currentStateMap.get(instance) != null && currentStateMap.get(instance).equals(HelixDefinedState.ERROR.name()) || !disabledInstancesForPartition.contains(instance) && isResourceEnabled) continue;
                instanceStateMap.put(instance, stateModelDef.getInitialState());
            }
        }
        if (instancePreferenceList == null) {
            return instanceStateMap;
        }
        List<String> statesPriorityList = stateModelDef.getStatesPriorityList();
        boolean[] assigned = new boolean[instancePreferenceList.size()];
        Map<String, LiveInstance> liveInstancesMap = cache.getLiveInstances();
        block3: for (String state : statesPriorityList) {
            String num = stateModelDef.getNumInstancesPerState(state);
            int stateCount = -1;
            if ("N".equals(num)) {
                HashSet<String> liveAndEnabled = new HashSet<String>(liveInstancesMap.keySet());
                liveAndEnabled.removeAll(disabledInstancesForPartition);
                stateCount = isResourceEnabled ? liveAndEnabled.size() : 0;
            } else if ("R".equals(num)) {
                stateCount = instancePreferenceList.size();
            } else {
                try {
                    stateCount = Integer.parseInt(num);
                }
                catch (Exception e) {
                    logger.error((Object)("Invalid count for state:" + state + " ,count=" + num));
                }
            }
            if (stateCount <= -1) continue;
            int count = 0;
            for (int i = 0; i < instancePreferenceList.size(); ++i) {
                boolean enabled;
                String instanceName = instancePreferenceList.get(i);
                boolean notInErrorState = currentStateMap == null || currentStateMap.get(instanceName) == null || !currentStateMap.get(instanceName).equals(HelixDefinedState.ERROR.toString());
                boolean bl = enabled = !disabledInstancesForPartition.contains(instanceName) && isResourceEnabled;
                if (!liveInstancesMap.containsKey(instanceName) || assigned[i] || !notInErrorState || !enabled) continue;
                instanceStateMap.put(instanceName, state);
                assigned[i] = true;
                if (++count == stateCount) continue block3;
            }
        }
        return instanceStateMap;
    }
}

